
Name: akonadi
Version: 1.13.1
Release: alt0.6

Group: Databases
Summary: An extensible cross-desktop storage service for PIM
Url: http://pim.kde.org/akonadi/
License: LGPLv2+

Requires: %name-database tar bzip2

Source: %name-%version.tar
Source10: mysql_install_db
# RH
Patch10: akonadi-1.7.0-mysql_conf.patch
# ALT
Patch101: akonadi-1.1.1-alt-alt-kdebindir.patch
Patch102: akonadi-1.3.81-alt-mysql-paths.patch
Patch103: akonadi-1.11.0-alt-pluginsdir.patch
#
Patch105: akonadi-1.11.0-alt-start-mysqlcheck.patch
Patch106: akonadi-1.6.2-alt-own-mysql_install_db.patch
Patch107: akonadi-1.6.2-alt-check-nepomuk.patch

BuildRequires(pre): libqt4-devel rpm-build-ubt
BuildRequires: gcc-c++ automoc
BuildRequires: libqt4-devel >= 4.4 kde-common-devel >= 4
BuildRequires: shared-mime-info >=  0.20
BuildRequires: pkg-config cmake xsltproc xml-utils
BuildRequires: boost-devel boost-program_options-devel libsqlite3-devel

%description
An extensible cross-desktop storage service for PIM data and meta data providing
concurrent read, write, and query access.


%package common
Summary: %name common mime and dbus calls
Group: System/Libraries
%description common
%name common mime and dbus calls.

%package -n libqt4-sql-sqlite3
Summary: SQLite3 driver for Qt4 SQL classes
Group: System/Libraries
Requires: qt4-common
Provides: libqt4-plugin-sql = 4.7
%description -n libqt4-sql-sqlite3
SQLite3 driver for Qt's SQL classes (QSQLITE3)

%package database-1-sqlite
Group: Databases
Summary: %name Qt sqlite database
BuildArch: noarch
Requires: %name-common = %EVR
Requires: libqt4-sql-sqlite
Provides: %name-database = %EVR
Provides: %name-database-sqlite = %EVR
Provides: akonadi-database0 = %EVR
Obsoletes: akonadi-database0 < %EVR
%description database-1-sqlite
%name Qt sqlite database

%package database-3-sqlite3
Group: Databases
Summary: %name sqlite database
BuildArch: noarch
Requires: %name-common = %EVR
Requires: libqt4-sql-sqlite3
Provides: %name-database = %EVR
Provides: %name-database-sqlite3 = %EVR
Provides: akonadi-database1 = %EVR
Obsoletes: akonadi-database1 < %EVR
%description database-3-sqlite3
%name sqlite database

%package database-5-postgresql
Group: Databases
Summary: %name postgresql database
BuildArch: noarch
Requires: %name-common = %EVR
Requires: libqt4-sql-postgresql postgresql /usr/bin/pg_dump /usr/bin/pg_restore
Provides: %name-database = %EVR
Provides: %name-database-postgresql = %EVR
Provides: akonadi-database2 = %EVR
Obsoletes: akonadi-database2 < %EVR
%description database-5-postgresql
%name postgresql database

%package database-8-mysql
Group: Databases
Summary: %name mysql database
BuildArch: noarch
Requires: %name-common = %EVR
Requires: libqt4-sql-mysql mariadb-server mariadb-client
Provides: %name-database = %EVR
Provides: %name-database-mysql = %EVR
Provides: akonadi-database3 = %EVR
Obsoletes: akonadi-database3 < %EVR
Provides: akonadi-database-7-mysql = %EVR
Obsoletes: akonadi-database-7-mysql < %EVR
%description database-8-mysql
%name mysql database

%package -n libakonadiprotocolinternals
Group: System/Libraries
Summary: %name library
Requires: %name-common = %EVR
%description -n libakonadiprotocolinternals
%name library

%package -n libakonadiprivate
Group: System/Libraries
Summary: %name library
Requires: %name-common = %EVR
%description -n libakonadiprivate
%name library

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: libqt4-devel libxml2-devel dbus
Conflicts: kde4pimlibs-devel < 4.0.70
Conflicts: kde4pim-devel < 4.0.70
%description devel
Development files for %name


%prep
%setup -q
#
%patch10 -p1
#
%patch101 -p1
%patch102 -p1
%patch103 -p1
#
%patch105 -p1
%patch106 -p1
%patch107 -p1

%build
#export PATH=%_libdir/kde4bin:$PATH
export CMAKE_LIBRARY_PATH=%_libdir
%Kcmake \
    -DQT5_BUILD=OFF \
    -DAKONADI_BUILD_TESTS=OFF \
    -DBIN_INSTALL_DIR2=%_kde4_bindir \
    -DCONFIG_INSTALL_DIR=%_sysconfdir \
    -DINCLUDE_INSTALL_DIR=%_includedir \
    -DMYSQLD_EXECUTABLE:FILEPATH=%_sbindir/mysqld \
    -DINSTALL_QSQLITE_IN_QT_PREFIX=ON \
    -DWITH_SOPRANO=FALSE \
    #
%Kmake


%install
%Kinstall
mkdir -p %buildroot/%_libdir/akonadi/contact/editorpageplugins/
install -m 0755 %SOURCE10 %buildroot/%_bindir/akonadi_mysql_install_db

%files common
%_K4xdg_mime/akonadi-mime.xml
%dir %_sysconfdir/akonadi/
%dir %_libdir/akonadi/
%dir %_libdir/akonadi/*/
%dir %_libdir/akonadi/*/*/

%files
%_bindir/akonadi_rds
%_bindir/akonadi_control
%_bindir/akonadictl
%_bindir/akonadiserver
%_bindir/akonadi_agent_launcher
%_bindir/akonadi_agent_server
%config(noreplace) %_sysconfdir/akonadi/*
%_K4dbus_services/org.freedesktop.Akonadi.Control.service

%files -n libqt4-sql-sqlite3
%_qt4dir/plugins/sqldrivers/libqsqlite3.so

%files database-1-sqlite
%files database-3-sqlite3
%files database-5-postgresql
%files database-8-mysql
%_bindir/akonadi_mysql_install_db

#%files -n libakonadiprivate
#%_libdir/libakonadiprivate.so.*

%files -n libakonadiprotocolinternals
%_libdir/libakonadiprotocolinternals.so.*

%files devel
%_K4dbus_interfaces/*.xml
%_includedir/*
%_libdir/cmake/Akonadi/
%_libdir/*.so
%_libdir/pkgconfig/*

%changelog
