# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-generic-compat rpm-macros-mageia-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name alglib
%define major     3
%define libname   lib%{name}%{major}
%define develname lib%{name}-devel

Name:           alglib
Version:        3.15.0
Release:        alt1_1
Summary:        A numerical analysis and data processing library
Group:          System/Libraries
License:        GPLv2+
URL:            http://www.alglib.net/
Source0:        http://www.alglib.net/translator/re/%{name}-%{version}.cpp.gpl.tgz
Source1:        ALGLIBConfig.cmake
# Extracted from manual.cpp.html
Source2:        bsd.txt

# Make test output more verbose
Patch0:         alglib_verbose-tests.patch
# From Debian:
Patch1:         01_add_cmake.patch

BuildRequires:  ccmake cmake ctest
BuildRequires:  gcc-c++
Source44: import.info

%description
ALGLIB is a cross-platform numerical analysis and data processing library.
ALGLIB features include:
 - Data analysis (classification/regression, including neural networks)
 - Optimization and nonlinear solvers
 - Interpolation and linear/nonlinear least-squares fitting
 - Linear algebra (direct algorithms, EVD/SVD), direct and iterative linear
   solvers, Fast Fourier Transform and many other algorithms (numerical
   integration, ODEs, statistics, special functions)


%package -n     %{libname}
Summary:        Shared %{name} library
Group:          System/Libraries

%description -n %{libname}
ALGLIB is a cross-platform numerical analysis and data processing library.
ALGLIB features include:
 - Data analysis (classification/regression, including neural networks)
 - Optimization and nonlinear solvers
 - Interpolation and linear/nonlinear least-squares fitting
 - Linear algebra (direct algorithms, EVD/SVD), direct and iterative linear
   solvers, Fast Fourier Transform and many other algorithms (numerical
   integration, ODEs, statistics, special functions)

This package provides the shared %{name} library.

%package -n     %{develname}
Summary:        Development files for %{name}
Group:          Development/C
Requires:       %{libname} >= %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}

%description -n %{develname}
The %{develname} package contains libraries and header files for
developing applications that use %{name}.

%package        doc
Group: System/Libraries
Summary:        API documentation for %{name}
License:        BSD
BuildArch:      noarch

%description    doc
The %{name}-doc package contains the %{name} API documentation.


%prep
%setup -q -n cpp
%patch0 -p1
%patch1 -p1
cp %{SOURCE1} .
cp %{SOURCE2} .

# Set version and soversion in cmake file
%define soversion %(echo %{version}|cut -d. -f1,4)
sed -i 's|\${VERSION}|%{version}|' CMakeLists.txt
sed -i 's|\${SOVERSION}|%{soversion}|' CMakeLists.txt

# Fix permissions and line endings
chmod 644 gpl2.txt
chmod 644 manual.cpp.html
sed -i 's|\r||g' manual.cpp.html


%build
# disable FMA support to get it pass all tests
%ifarch aarch64 %{power64} s390 s390x
export CXXFLAGS="%{optflags} -ffp-contract=off"
export CFLAGS="%{optflags} -ffp-contract=off"
%endif
%{mageia_cmake}
%make_build


%install
%makeinstall_std -C build

%if 0
%check
pushd build
# FIXME Temporarily ignore test failures on test_c due to GCC7 test failure on i686, see
# http://bugs.alglib.net/view.php?id=689
%ifarch %{ix86}
LD_LIBRARY_PATH=$PWD ./test_c || true
%else
LD_LIBRARY_PATH=$PWD ./test_c || false
%endif
LD_LIBRARY_PATH=$PWD ./test_i || false
popd
%endif

%files -n %{libname}
%doc --no-dereference gpl2.txt
%{_libdir}/libalglib.so.%{major}*

%files -n %{develname}
%{_includedir}/%{name}/
%{_libdir}/libalglib.so
%{_libdir}/cmake/ALGLIB/

%files doc
%doc --no-dereference bsd.txt
%doc manual.cpp.html


%changelog
