# -*- rpm-spec -*-
# $Id: alicq.spec,v 1.76 2005/08/04 14:03:06 grigory Exp $

Name: alicq
Version: 0.8.9
Release: alt6.qa3

Summary: alicq - Flexible ICQ client in pure Tcl/Tk
License: GPL
Group: Networking/Instant messaging
URL: http://alicq.sourceforge.net/

BuildArch: noarch
Source0: %name-%version.tar.bz2

Requires: bwidget tk >= 8.3
Requires: tcl-icq >= 0.8.9
BuildRequires: rpm-build >= 4.0.4 tcl >= 8.3 tcllib xsltproc rpm-build-tcl

%description
   Alicq is pure Tcl/Tk implementation of ICQ client with flexible
modularized architecture, support for ICQv8 (ICQ2000/OSCAR) protocol,
and ability to pick up Licq configuration files and user database.

Why would you use it? It is small, about 2500 lines as of release
0.6. It is modular and extendable in best tradition of the Tcl
scripting language. New modules are easy to write, and dozen lines
Tcl module can do a lot. It is crossplatfrom: works on Unix, Windows,
Macintosh, and on any other system supported by Tcl/Tk.


%package -n tcl-icq
Summary: This library gives ability to use ICQ v8 protocol (OSCAR) in tcl programs
Group: Development/Tcl
Requires: tcl >= 8.3

%description -n tcl-icq
Protocol description and some ideas in implementattion were taken from
ICQ2000.pm and ICQ2000_Easy.pm perl modules by
Robin Fisher <robin@phase3solutions.com> and vICQ program by
Alexander Timoshenko

%add_tcl_lib_path %_datadir/%name

%prep
%setup -q -c
sed -i -e 's|check-tcl||g' Makefile

%build

%install 
%makeinstall package=%name tcldatadir=%buildroot%_datadir/%name/lib
%makeinstall -C icq package=tcl-icq tcldatadir=%buildroot%_tcldatadir

# menu stuff JONS GTK
mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=Alicq
Comment=tcl/tk ICQ client
Icon=%{name}
Exec=%name
Terminal=false
Categories=Network;InstantMessaging;
EOF

install -d -m 755 %buildroot%_miconsdir
install -p -m 0644 %name.xpm %buildroot%_miconsdir/%name.xpm

%files
%doc doc/{changelog,INSTALL,README,TODO,alicqrc.sample}
%dir %_datadir/%name
%dir %_datadir/%name/lib
%_bindir/*
%_datadir/%name/*
%_desktopdir/%{name}.desktop
%_miconsdir/%name.xpm
#%_man1dir/*
#%_man5dir/*

%files -n tcl-icq
%doc icq/examples/* icq/doc/{changelog,README,TODO}
%dir %_tcldatadir/tcl-icq
%_tcldatadir/tcl-icq/*
%_mandir/mann/*

%changelog
