%define oname allegro
%define _optlevel 3

%def_disable static
%set_verify_elf_method unresolved=relaxed,textrel=relaxed

%define major 4
%define minor 4
%define bugfix 2
%define sover 4.4
Name: %oname%sover
Version: %major.%minor.%bugfix
Release: alt6

Group: System/Libraries
Summary: Game programming library
License: Giftware 
URL: http://alleg.sourceforge.net
Packager: Repocop Q. A. Robot <repocop@altlinux.org>

Source0: http://sunsite.auc.dk/allegro/%name-%version.tar
Patch0: allegro-4.0.1-allegro.h.patch
Patch1: allegro-4.1.8-allegro.h.patch
Patch2: allegro-4.4.2-allegrogl.patch
Patch3: allegro-4.4.2-allegro.h.patch

Obsoletes: %name
Conflicts: lib%oname-svgalib < %version-%release

BuildRequires: esound-devel gcc-c++ glib2-devel libalsa-devel 
BuildRequires: libjack-devel libaudiofile-devel pkgconfig cmake
BuildRequires: libX11-devel libGL-devel libGLU-devel libXxf86dga-devel
BuildPreReq: libXtst-devel libXcomposite-devel libXcursor-devel
BuildPreReq: libXft-devel libXi-devel libXinerama-devel libXpm-devel
BuildPreReq: libXrender-devel libXrandr-devel libXt-devel libXv-devel
BuildPreReq: libXxf86misc-devel libICE-devel
BuildPreReq: libpng-devel zlib-devel libogg-devel libvorbis-devel
BuildPreReq: libXxf86vm-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%package -n lib%name
Group: System/Libraries
Summary: Game programming library

%package -n lib%oname-devel
Group: Development/C
Summary: Game programming library development files
Requires: lib%name = %version-%release
Provides: allegro-devel = %version-%release
Obsoletes: allegro-devel

%description
Allegro is a library of functions for use in computer games.

%description -n lib%name
Allegro is a library of functions for use in computer games.

%description -n lib%oname-devel
Allegro is a library of functions for use in computer games.

This package contains files needed to build programs using Allegro.

%prep
%setup
%patch2 -p1

%build
mkdir Build
pushd Build

FLAGS="-fno-strict-aliasing %optflags %optflags_shared"
cmake \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DCMAKE_CXX_FLAGS:STRING="$FLAGS" \
	-DCMAKE_C_FLAGS:STRING="$FLAGS" \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DWANT_LINUX_CONSOLE:BOOL=ON \
	-DWANT_LINUX_VGA:BOOL=OFF \
	-DDOCDIR:STRING=share/doc \
	-DINFODIR:STRING=share/info \
%if "%_lib" == "lib64"
	-DLIB_SUFFIX:STRING=64 \
%endif
	..
%make_build

popd

%install
%makeinstall_std -C Build modulebasedir=%buildroot/%_libdir/allegro

install -Dpm 644 allegro.cfg %buildroot%_sysconfdir/allegrorc
install -pm 755 tools/x11/xfixicon.sh %buildroot%_bindir
install -m 755 Build/docs/makedoc %buildroot%_bindir/allegro-makedoc
install -dm 755 %buildroot%_datadir/allegro
install -pm 644 keyboard.dat language.dat %buildroot%_datadir/allegro

gzip CHANGES

%files -n lib%name
%doc readme.txt AUTHORS CHANGES* THANKS
%dir %_libdir/allegro
%dir %_libdir/allegro/%major.%minor.%bugfix
%_libdir/*.so.*
%_libdir/allegro/%major.%minor.%bugfix/alleg-dga2.so
%_libdir/allegro/%major.%minor.%bugfix/modules.lst
%_libdir/allegro/%major.%minor.%bugfix/alleg-alsadigi.so
%_libdir/allegro/%major.%minor.%bugfix/alleg-alsamidi.so
%_libdir/allegro/%major.%minor.%bugfix/alleg-jack.so
%_libdir/allegro/%major.%minor.%bugfix/alleg-fbcon.so
#_libdir/allegro/%major.%minor.%bugfix/alleg-vga.so
%_sysconfdir/allegrorc
%_datadir/allegro

%files -n lib%oname-devel
%dir %_datadir/doc/%oname-%major.%minor.%bugfix
%doc %_datadir/doc/%oname-%major.%minor.%bugfix/*
%_bindir/*
%_includedir/*
%_libdir/*.so
%_infodir/*
%_pkgconfigdir/*

%changelog
