Name: alsa-plugins
Version: 1.2.2
Release: alt2
Epoch: 1

Summary: Advanced Linux Sound Architecture (ALSA) plugins
License: LGPLv2.1+
Group: System/Libraries

Url: http://www.alsa-project.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ libalsa-devel libavcodec-devel libdbus-devel
BuildRequires: libpulseaudio-devel libsamplerate-devel libspeex-devel libspeexdsp-devel

%define _unpackaged_files_terminate_build 1

Summary(ru_RU.UTF-8): Плагины ALSA
Summary(uk_UA.UTF-8): Плагіни ALSA

%description
Advanced Linux Sound Architecture (ALSA) plugins.

%description -l ru_RU.UTF-8
Этот пакет содержит плагины ALSA.

%description -l uk_UA.UTF-8
Цей пакунок містить плагіни ALSA.

%package pulse
Summary: ALSA pulseaudio plugin
Group: Sound
Requires: libalsa >= 1.0.21a
Requires: pulseaudio-daemon

%description pulse
ALSA pulseaudio plugin

%prep
%setup
%patch -p1

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

# drop unneeded files
find %buildroot%_libdir/alsa-lib/ -name '*.la' -delete

# install configs from Debian
install -D pulse-alsa.conf %buildroot%_datadir/alsa/pulse-alsa.conf
install -D pulse.conf %buildroot%_datadir/alsa/alsa.conf.d/99-pulse.conf

# turn symlinks into relative ones
find %buildroot%_sysconfdir/alsa/conf.d/ -type l -delete
for i in %buildroot%_datadir/alsa/alsa.conf.d/*.conf; do
	ln -sr "$i" %buildroot%_sysconfdir/alsa/conf.d/
done

%files
# I know of README-pulse, too much hassle with merging docdirs
%doc doc/*.txt doc/README-*
%config(noreplace) %_sysconfdir/alsa/conf.d/*.conf
%exclude %_sysconfdir/alsa/conf.d/*pulse*.conf
%_datadir/alsa/alsa.conf.d/*.conf
%exclude %_datadir/alsa/alsa.conf.d/*pulse*.conf
%_libdir/alsa-lib/*.so
%exclude %_libdir/alsa-lib/*pulse*.so

%files pulse
%_libdir/alsa-lib/*pulse*.so
%_sysconfdir/alsa/conf.d/99-pulseaudio-default.conf.example
%_sysconfdir/alsa/conf.d/50-pulseaudio.conf
%_sysconfdir/alsa/conf.d/99-pulse.conf
%_datadir/alsa/pulse-alsa.conf
%_datadir/alsa/alsa.conf.d/50-pulseaudio.conf
%_datadir/alsa/alsa.conf.d/99-pulse.conf

%changelog
