%define _altdata_dir %_datadir/alterator

Name: alterator-setup
Version: 0.3.9
Release: alt1

Summary: Perform initial setup of an OEM installation (warning!)
License: GPLv2
Group: System/Configuration/Other

Url: http://www.altlinux.org/Alterator
Source: %name-%version.tar

BuildArch: noarch
BuildPreReq: alterator >= 4.10-alt6
BuildRequires: rpm-macros-alterator

Requires: libshell
Requires: alterator-l10n >= 2.5-alt1
Requires: alterator-browser-qt >= 2.17.0
Requires: alterator-lookout => 2.4-alt1
Requires: alterator-wizardface
Requires: alterator-notes
Requires: alterator-sysconfig
Requires: alterator-datetime
Requires: alterator-root
Requires: alterator-users

Requires(post): chkconfig
Requires(preun): chkconfig

Conflicts: alterator-livecd
Conflicts: installer-common-stage2

%description
%summary

WARNING: you really don't want to install this package
into an already configured system as it may spoil the
next boot!  Given that its sole purpose is the _initial_
configuration of a new system (like setting root password)
nobody should need that on an up-and-running host.

%package x11vnc
Summary: Perform initial setup of an OEM installation through VNC (warning!)
Group: System/Configuration/Other
Requires: x11vnc-service
Requires: %name
Requires: alterator-vnc

%description x11vnc
This is a X11 VNC version of the alterator setup package.

WARNING: you really don't want to install this package
into an already configured system as it may spoil the
next boot!  Given that its sole purpose is the _initial_
configuration of a new system (like setting root password)
nobody should need that on an up-and-running host.

%prep
%setup

%install
%makeinstall

cat >> %buildroot%_sysconfdir/alterator-setup/config << EOF
# erase %name and related packages
REMOVE_SELF=1
EOF

%files
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/config
%_initdir/setup
%_sbindir/%name
%_alterator_datadir/steps/*
%exclude %_alterator_datadir/steps/vnc.desktop
%_alterator_datadir/ui/*
%_alterator_libdir/hooks/*/*
%_alterator_backend3dir/*
%_datadir/alterator-setup/
/lib/systemd/system/setup.service
/lib/systemd/system/setup.target
%config(noreplace) %_sysconfdir/%name/steps

%files x11vnc
%_initdir/setup-vnc
/lib/systemd/system/setup-vnc.service
/lib/systemd/system/setup-vnc.target
%_alterator_datadir/steps/vnc.desktop
%config(noreplace) %_sysconfdir/%name/steps-vnc

# the restore is done in postinstall script
# triggered by successful completion of the module
# as it can be reused now (doesn't self destruct)
%post
[ ! -f /lib/systemd/system/setup-vnc.target ] || exit 0
%post_service setup
[ -d /etc/systemd/system ] || exit 0
mv /etc/systemd/system/default.target /etc/systemd/system/default.target.bak ||:
ln -sf /lib/systemd/system/setup.target /etc/systemd/system/default.target

%post x11vnc
%post_service setup-vnc
[ -d /etc/systemd/system ] || exit 0
mv /etc/systemd/system/default.target /etc/systemd/system/default.target.bak ||:
ln -sf /lib/systemd/system/setup-vnc.target /etc/systemd/system/default.target

# package is removed in postinstall hook, but
# 'systemd stop' stops whole setup.service with hook.
%preun
if [ -x /sbin/sd_booted -a ! -f /lib/systemd/system/setup-vnc.target ]; then
/sbin/sd_booted || %preun_service setup
fi

%preun x11vnc
if [ -x /sbin/sd_booted ]; then
/sbin/sd_booted || %preun_service setup-vnc
fi

%changelog
