# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           amora
Version:        1.1
Release:        alt2_21
Summary:        A mobile remote assistant

Group:          Communications
License:        GPLv2+
URL:            http://code.google.com/p/amora
Source0:        http://amora.googlecode.com/files/amora-server-%{version}.tar.gz
Patch0:         amora-aarch64.patch

BuildRequires:  libbluez-devel
BuildRequires:  libdbus-devel
BuildRequires:  gcc
BuildRequires:  imlib2-devel
BuildRequires:  libX11-devel
BuildRequires:  libXi-devel
BuildRequires:  libXtst-devel
Source44: import.info

%description
Amora is an application that enables you to control your PC desktop using a
cellphone. It uses bluetooth to send mouse and keyboard events to the
graphical session. With it you can control your slides in OpenOffice.org,
movies or any other application. Amora also has a screenshot feature, where
you can see a thumbnail in the cellphone screen of the currently focused
window in your desktop.

In order to use amora, you need a mobile phone with amora-client
installed and running. The current client is implemented in Python
for S60 (Nokia cellphones) and is available at
http://code.google.com/p/amora/

%prep
%setup -q -n amora-server-%{version}
#patch to build on aarch64, upstream notified to use autoconf 2.69
%patch0 -p 1


%build
%configure
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"


%files
%doc README
%doc --no-dereference COPYING
%{_bindir}/amorad
%{_mandir}/man7/amora.7*
%{_mandir}/man8/amorad.8*

%changelog
