Name: ansible
Summary: SSH-based configuration management, deployment, and task execution system
Version: 2.9.27
Release: alt1

Group:   System/Configuration/Other
License: GPL-3.0
Source0: %name-%version.tar
Source1: hacking.tar

Patch0: %name-alt.patch
Patch1: ansible-apt_rpm-list-of-packages-support.patch
Patch2: ansible_native_concat-use-to_text-rather-than-jinja2.patch
Patch3: ansible-prohibit-pkg5-usage.patch

Url: http://www.ansible.com

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildArch: noarch
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-six
BuildRequires: python3-module-setuptools
BuildRequires: asciidoc-a2x
BuildRequires: python3-module-jinja2
BuildRequires: python3-module-yaml
BuildRequires: python-modules-json
BuildRequires: python3-module-packaging
BuildRequires: python3-module-docutils
BuildRequires: python3-module-straight-plugin

Requires: ca-certificates >= 2015.10.29

%py3_requires yaml
%py3_requires paramiko

# Skip findreq on all modules:
%add_findreq_skiplist %python3_sitelibdir/%name/modules/*
%add_findreq_skiplist %python3_sitelibdir/%name/plugins/*
%add_findreq_skiplist %python3_sitelibdir/%name/module_utils/ansible_tower.py

%add_python3_req_skip __main__

%py3_provides ansible.module_utils.six.moves
%py3_provides ansible.module_utils.six.moves.http_cookiejar
%py3_provides ansible.module_utils.six.moves.urllib.error
%py3_provides ansible.module_utils.six.moves.urllib.parse
%py3_provides ansible.module_utils.six.moves.urllib.request

%filter_from_requires /^eepm-yum$/d
%filter_from_requires /pip$/d

%description
Ansible is a radically simple model-driven configuration management,
multi-node deployment, and remote task execution system. Ansible works
over SSH and does not require any software or daemons to be installed
on remote nodes. Extension modules can be written in any language and
are transferred to managed machines automatically.

%prep
%setup
# Restore non-exported hacking subdirectory
tar xf %SOURCE1
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%python3_build

%install
%python3_install
mkdir -p %buildroot%_sysconfdir/%name/
cp examples/ansible.cfg %buildroot%_sysconfdir/%name/
touch %buildroot%_sysconfdir/%name/hosts
mkdir -p %buildroot/%_man1dir
make PYTHON=python3 docs
cp -v docs/man/man1/*.1 %buildroot/%_man1dir/

# ansible-test is a tool for ansible development only
rm -rf %buildroot%python3_sitelibdir/ansible_test
rm -rf %buildroot%prefix/bin/ansible-test
# Fix shebangs
grep -Rl '^#!.*python$' %buildroot | xargs subst 's|^#!.*python$|#!%__python3|'

%files
%_bindir/%{name}*
%config(noreplace) %_sysconfdir/%name
%_man1dir/%{name}*
%python3_sitelibdir/%{name}*
%doc examples/playbooks examples/scripts examples/hosts
%doc README.rst changelogs/CHANGELOG-v*.rst CODING_GUIDELINES.md MODULE_GUIDELINES.md

%changelog
