%define php7_sapi apache2-mod_php
%define so_file  mod_php7.so

Name: apache2-mod_php7
Version: %php7_version
Release: %php7_release.3

Summary: The php7 HTML-embedded scripting language for use with Apache2

Group: System/Servers
License: PHP-3.01
Url: http://www.php.net/

Source1: php.ini
Source2: %name-browscap.ini

Patch0: apache2-mod_php7-7.1.0.patch
Patch1: php-alt-namespace.patch

BuildRequires(pre): rpm-build-php7 rpm-macros-apache2
BuildRequires: apache2-devel apache2-httpd-worker libmm-devel libxml2-devel php7-devel zlib-devel libsqlite3-devel
BuildRequires: php7-devel = %php7_version

Requires: php7 = %php7_version
Requires: php7 >= %php7_version-%php7_release
Requires: apache2-httpd-prefork-like
Requires(post): apache2-httpd-prefork-like
Requires(post): apache2-base

Conflicts: apache2-mod_php5
Provides: php-engine = %php7_version-%php7_release

%description
PHP is an HTML-embedded scripting language. PHP attempts to make it
easy for developers to write dynamically generated web pages. PHP
also offers built-in database integration for several commercial
and non-commercial database management systems, so writing a
database-enabled web page with PHP is fairly simple. The most
common use of PHP coding is probably as a replacement for CGI
scripts. The mod_php module enables the Apache web server to
understand and process the embedded PHP language in web pages.

This package contains PHP version 5. You'll also need to install the
Apache2 web server.


%prep
%setup -T -c
%php7_sapi_prepare apache2handler
%patch0 -p1 -b .fix
%patch1 -p1 -b .fix1

%build
rm -f internal_functions.c

%apache2_apxs \
  $(php-config7 --includes) \
  $(php-config7 --ldflags) %php7_optflags \
  $(php-config7 --libs) \
  -I. -I./include -I/usr/include/apache -Iext/date/lib -I/usr/include/libxml2 \
  -DUSE_TRANSFER_TABLES=1 \
  -lphp-%_php7_version \
  -o %so_file -c *.c

%install
mkdir -p \
	%buildroot/%apache2_mods_available \
	%buildroot/%apache2_mods_start \
	%buildroot/%apache2_moduledir \
	%buildroot/%php7_sysconfdir/%php7_sapi/php.d \
	%buildroot/%_rpmlibdir

cp .libs/%so_file %buildroot/%apache2_moduledir

cat > %buildroot/%apache2_mods_available/mod_php7.load <<EOF
LoadModule php7_module %apache2_moduledir/mod_php7.so
EOF

cat > %buildroot/%apache2_mods_available/mod_php7.conf <<EOF
<IfModule mod_php7.c>
    AddType    application/x-httpd-php7-source   .phps
    AddType    application/x-httpd-php7          .php .php5 .php4 .php3 .phtml
    AddHandler application/x-httpd-php7          .php .php5 .php4 .php3 .phtml
</IfModule>
EOF

cat > %buildroot/%apache2_mods_start/mod_php7.conf << EOF
mod_php7=yes
EOF

cat > %buildroot/%_rpmlibdir/90-php-%name.filetrigger << EOF
#!/bin/sh
LC_ALL=C sed 's|^%php7_sysconfdir/%php7_sapi/control.d||' |
        egrep -qs '^%php7_sysconfdir/%php7_sapi|^%php7_extdir' || exit 0
%post_apache2conf
EOF
chmod 755 %buildroot/%_rpmlibdir/90-php-%name.filetrigger

install -m 644 %SOURCE1 %buildroot/%php7_sysconfdir/%php7_sapi/php.ini
install -m 644 %SOURCE2 %buildroot/%php7_sysconfdir/%php7_sapi/browscap.ini

for f in \
	%buildroot/%php7_sysconfdir/%php7_sapi/php.ini
do
  subst 's,@SAPI@,%php7_sapi,g' "$f"
  subst 's,@PHP_VERSION@,%_php7_version,g' "$f"
  subst 's,@PHP_MAJOR@,%_php7_major,g' "$f"
  subst 's,@PHP_LIBDIR@,%_libdir/php,g' "$f"
  subst 's,@HTDOCSDIR@,%apache2_htdocsdir,g' "$f"
  subst 's,@PHP_BROWSCAP@,%php7_sysconfdir/%php7_sapi/browscap.ini,g' "$f"
  subst 's,@PHP_UPLOADDIR@,%apache2_spooldir/uploads,g' "$f"
  subst 's,@PHP_SESSIONDIR@,%apache2_spooldir/sessions,g' "$f"
done

%preun
%php7_sapi_preun

%files
%config(noreplace) %apache2_mods_available/*
%config(noreplace) %apache2_mods_start/*
%dir %php7_sysconfdir/%php7_sapi
%dir %php7_sysconfdir/%php7_sapi/php.d
%config(noreplace) %php7_sysconfdir/%php7_sapi/php.ini
%config(noreplace) %php7_sysconfdir/%php7_sapi/browscap.ini
%apache2_moduledir/%so_file
%_rpmlibdir/90-php-%name.filetrigger
%doc CREDITS


%changelog
