# Filter GLIBC_PRIVATE Requires, see wrappers/dlsym.cpp
#define __filter_GLIBC_PRIVATE 1

Name: apitrace
Version: 7.1
Release: alt2

Summary: Tools for tracing OpenGL

License: MIT
Group: Graphics
Url: http://apitrace.github.io/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://github.com/apitrace/apitrace/archive/%version/apitrace-%version.tar
Source1: qapitrace.desktop
Source2: qapitrace.appdata.xml

# Unbundle gtest
Patch: apitrace-7.1_gtest.patch

# due https://bugzilla.altlinux.org/show_bug.cgi?id=35067
%remove_optflags -O2
%add_optflags -O1

BuildRequires: cmake ctest
BuildRequires: qt5-base-devel
BuildRequires: qt5-webkit-devel
BuildRequires: python-devel
BuildRequires: libpng-devel
BuildRequires: libsnappy-devel
BuildRequires: desktop-file-utils
#BuildRequires: libappstream-glib
BuildRequires: libgtest-devel
BuildRequires: libdwarf-devel
# for gui tools
BuildRequires: libX11-devel

#Requires: %name-libs = %version-%release
# scripts/snapdiff.py
#Requires: python-module-pillow

# See http://fedoraproject.org/wiki/Packaging:No_Bundled_Libraries#Packages_granted_exceptions
#Provides: bundled(md5-plumb)
# See https://fedorahosted.org/fpc/ticket/429
#Provides: bundled(libbacktrace)

%description
apitrace consists of a set of tools to:
 * trace OpenGL and OpenGL ES  APIs calls to a file;
 * replay OpenGL and OpenGL ES calls from a file
 * inspect OpenGL state at any call while retracing
 * visualize and edit trace files

%package -n lib%name
Summary: Libraries used by apitrace
Requires: %name = %version-%release
Group: Graphics

%description -n lib%name
Libraries used by apitrace

%package gui
Summary: Graphical frontend for apitrace
Requires: %name = %version-%release
Group: Graphics

%description gui
This package contains qapitrace, the Graphical frontend for apitrace.

%prep
%setup
%patch -p1

# Remove bundled libraries, except khronos headers and libbacktrace
# TODO:
# https://bugzilla.redhat.com/show_bug.cgi?id=1507659
#rm -rfv `ls -1d thirdparty/* | grep -Ev "(khronos|md5|libbacktrace)"`

# Fix shebangs
#find scripts -name '*.py' | xargs sed -i '1s|^#!.*python|#!%__python2|'

# Fix spurious-executable-perm
chmod -x retrace/glretrace_main.cpp

%build
%cmake_insource
%make_build

%install
%makeinstall_std

# Install doc through %%doc
rm -rf %buildroot%_docdir/

# Install desktop file
desktop-file-install --dir=%buildroot%_desktopdir/ %SOURCE1

# Install appdata file
install -Dpm 0644 %SOURCE2 %buildroot%_datadir/appdata/qapitrace.appdata.xml
#%_bindir/appstream-util validate-relax --nonet %buildroot%_datadir/appdata/qapitrace.appdata.xml

# highlight.py is not a script
#chmod 0644 %buildroot%_libdir/%name/scripts/highlight.py

%check
make check

#post gui
#_bindir/update-desktop-database &> /dev/null || :

#postun gui
#_bindir/update-desktop-database &> /dev/null || :

%files
%doc LICENSE
%doc README.markdown docs/*
%_bindir/apitrace
%_bindir/eglretrace
%_bindir/glretrace

#files -n lib%name
%_libdir/%name/

%files gui
%_bindir/qapitrace
%_desktopdir/qapitrace.desktop
%_datadir/appdata/qapitrace.appdata.xml

%changelog
