# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:      arc
Version:   5.21p
Release:   alt1_10
Summary:   Arc archiver
Group:     Archiving/Other
License:   GPL+
URL:       http://arc.sourceforge.net/
Source0:   http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
# 2 small polish patches courtesy of Debian
Patch0:    arc-5.21p-spelling.patch
Patch1:    arc-5.21p-manpage-section-fix.patch
# Arc was once shareware, but has been relicensed to the GPL with permission
# of its original author. But there still is some confusing license text in the
# docs this clarifies those parts of the text (rhbz#947786)
Patch2:    arc-5.21p-clarify-license.patch
# Fix reading v1 headers
Patch3:    arc-5.21p-hdrv1-read-fix.patch
# Fix arcdie crash
Patch4:    arc-5.21p-fix-arcdie.patch
# https://bugzilla.redhat.com/show_bug.cgi?id=1179143
Patch5:    arc-5.21p-directory-traversel.patch
Source44: import.info

%description
Arc file archiver and compressor. Long since superseded by zip/unzip
but useful if you have old .arc files you need to unpack.


%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
sed -i -e 's,^OPT =.*$,OPT = ${RPM_OPT_FLAGS},' Makefile


%build
%make_build


%install
install -m 0755 -d %{buildroot}{%{_bindir},%{_mandir}/man1}
install -m 0755 arc marc %{buildroot}%{_bindir}
install -m 0644 arc.1 marc.1 %{buildroot}%{_mandir}/man1/


%files
%doc LICENSE COPYING PATCHLEVEL Readme Arc521.doc
%{_bindir}/*
%{_mandir}/man1/*


%changelog
