Name: audacity
Version: 2.3.2
Release: alt3
Summary: Cross-platform audio editor
Summary(ru_RU.UTF-8): Кроссплатформенный звуковой редактор
License: GPL
Group: Sound

Url: http://audacity.sourceforge.net/
# Source0: https://github.com/audacity/audacity/archive/Audacity-%{version}.tar.gz
# https://www.fosshub.com/Audacity.html/audacity-manual-%{version}.zip
Source0: %name-minsrc-%version.tar
Source2: %name-48x48.xpm
Source3: %name-32x32.xpm
Source4: %name-16x16.xpm
Source6: %name-%version-help-en.tar

Patch1: 0001-Fix-building-with-wxWidgets-3.1.2.patch
Patch2: 0002-Fix-Ru-translation-of-signed-and-float.patch

# Debian patches are from https://salsa.debian.org/multimedia-team/audacity/tree/master/debian/patches
# NetBSD patches are from http://ftp.netbsd.org/pub/pkgsrc/current/pkgsrc/audio/audacity/patches/
# openSUSE patches are from https://build.opensuse.org/package/show/openSUSE:Leap:15.0/audacity
# ROSA patches are from https://abf.io/import/audacity/tree/rosa2016.1
Patch20: Debian-0004-desktop.patch
Patch50: NetBSD-ALT-Session-directory-in-home.patch
Patch60: ALT-system-sbsms.patch
# maybe useful when backporting to p8
Patch130: NetBSD-ffmpeg3.patch
Patch140: Fedora-libmp3lame-default.patch
Patch170: ALT-Remove-warning-about-alpha-version.patch

# Patents on mp3 (liblame) expired in April 2017
BuildRequires: gcc-c++ libportaudio2-devel libstdc++-devel-static libfftw3-devel gettext-devel libjpeg-devel ladspa_sdk liblame-devel
BuildRequires: libflac++-devel >= 1.3.1
BuildRequires: libflac-devel >= 1.3.1
# pkconfig BuildRequires are based on ROSA's spec: https://abf.io/import/audacity/blob/rosa2016.1/audacity.spec
# and OpenSUSE's spec: https://build.opensuse.org/package/view_file/openSUSE:Leap:15.0/audacity/audacity.spec
BuildRequires: desktop-file-utils shared-mime-info
BuildRequires: libopencore-amrnb0 libopencore-amrwb0
BuildRequires: ImageMagick zip
# For Audacity 2.2.2, we need wxWidgets 3.0, built without STL, either gtk3 or gtk2
BuildRequires: libwxGTK3.1-devel >= 3.1.1-alt2
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(flac++)
BuildRequires: pkgconfig(id3tag)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(lilv-0)
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(mad)
BuildRequires: pkgconfig(ogg)
BuildRequires: pkgconfig(samplerate)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(soundtouch)
BuildRequires: pkgconfig(soxr)
BuildRequires: pkgconfig(speex)
BuildRequires: pkgconfig(suil-0)
BuildRequires: pkgconfig(twolame)
BuildRequires: pkgconfig(udev)
BuildRequires: pkgconfig(vamp-hostsdk)
BuildRequires: pkgconfig(vorbis)
BuildRequires: pkgconfig(vorbisenc)
BuildRequires: pkgconfig(vorbisfile)
BuildRequires: pkgconfig(zlib)
BuildRequires: libsbsms-devel >= 2.0.2-alt2

%description
Audacity is a program that lets you manipulate digital audio waveforms.
It imports many sound file formats, including WAV, AIFF, AU, IRCAM,
MP3, and Ogg Vorbis. It supports all common editing operations such
as Cut, Copy, and Paste, plus it will mix tracks and let you apply
plug-in effects to any part of a sound.

%description -l ru_RU.UTF-8
Audacity - программа, которая дает возможность обрабатывать звукозаписи
в цифровом виде. Она может импортировать множество аудиоформатов, в т.ч.
WAV, AIFF, AU, IRCAM, MP3, Ogg Vorbis, и поддерживает все основные
операции редактирования, такие как Вырезать, Скопировать, Вставить,
а также возможность микширования дорожек и применения эффектов,
предоставляемых подключаемыми модулями, к любой части звука.

%package manual
Summary: Audacity manual (offline install)
Group: Documentation
BuildArch: noarch

%description manual
Audacity Manual can be installed locally if preferred, or accessed
on-line if internet connection is available.

For the most up to date manual content, use the on-line manual.

%prep
%setup -n %name-src-%version

%patch1 -p1
%patch2 -p1

%patch20 -p1
%patch50 -p1
%patch60 -p1
%patch130 -p0
%patch140 -p1
%patch170 -p1

grep -Irl "libmp3lame.so" . | xargs sed -i "s/libmp3lame.so/libmp3lame.so.0/" || true
sed -i -e 's,/usr/lib/ladspa,%{_libdir}/ladspa,g' src/effects/ladspa/LadspaEffect.cpp

%build
# src/RevisionIdent.h is in src/.gitignore and may be missing, what leads to build errors, but it's empty in release tarballs
[ ! -f src/RevisionIdent.h ] && echo ' ' > src/RevisionIdent.h

%global optflags %{optflags} -fno-strict-aliasing
%ifarch mips mipsel mips32 mips64
export LDFLAGS="${LDFLAGS} -latomic"
%endif

aclocal -I m4
%autoreconf

# From SUSE's spec about PortAudio:
# 'This [using system PortAudio] would require to patch our portaudio package with "PortMixer"... an extra API that never got integrated in PortAudio'
%configure \
	--enable-sse \
	--enable-dynamic-loading=no \
	--disable-dynamic-loading \
	--enable-nyquist \
	--enable-ladspa \
	--enable-vst \
	--with-expat=system \
	--with-ffmpeg=system \
	--with-lame=system \
	--with-libflac=system \
	--with-libid3tag=system \
	--with-libmad=system \
	--with-sbsms=system \
	--with-libsndfile=system \
	--with-soundtouch=system \
	--with-libsoxr=system \
	--with-libtwolame=system \
	--with-libvamp=system \
	--with-libvorbis=system \
	--with-lv2=system \
	--with-portaudio=local \
	--with-midi=local \
	--without-xaudio \
	--with-widgetextra=local \
%ifnarch %ix86 x86_64 %e2k
	--disable-sse
%else
	--enable-sse
%endif

%make_build

%install
%makeinstall_std
[ ! -f %buildroot%_liconsdir/%name.xpm ] && install -pDm644 %SOURCE2 %buildroot%_liconsdir/%name.xpm
[ ! -f %buildroot%_niconsdir/%name.xpm ] && install -pDm644 %SOURCE3 %buildroot%_niconsdir/%name.xpm
[ ! -f %buildroot%_miconsdir/%name.xpm ] && install -pDm644 %SOURCE4 %buildroot%_miconsdir/%name.xpm
tar -xf %SOURCE6 -C %buildroot%_datadir/%name
rm -rf %buildroot%_defaultdocdir/%name
%find_lang %name

%files -f %name.lang
%doc CHANGELOG.txt CODE_OF_CONDUCT.md CONTRIBUTING.md LICENSE.txt README.txt todo.txt
%_bindir/*
%_mandir/man?/*
%_iconsdir/*/*/apps/%name.*
%_liconsdir/*
%_niconsdir/*
%_miconsdir/*
%dir %_datadir/%name
%exclude %_datadir/%name/help
%_datadir/%name/*
%_datadir/applications/%name.desktop
%_datadir/mime/packages/%name.xml
%_datadir/appdata/%name.appdata.xml
%_datadir/icons/hicolor/*/apps/%name.*
%_pixmapsdir/*.xpm

%files manual
%dir %_datadir/%name
%_datadir/%name/help

%changelog
