%define realname autoconf
%define dialect _2.50
%define suff -2.5

Name: %realname%dialect
Version: 2.59
Release: alt12
Epoch: 2

Summary: A GNU tool for automatically configuring source code
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/%realname/
BuildArch: noarch

%set_compress_method xz
%define srcname %realname-%version
%define __spec_autodep_custom_pre export autom4te_perllibdir=%buildroot%_datadir/%realname%suff

Source: ftp://ftp.gnu.org/gnu/autoconf/%srcname.tar
Patch1: autoconf-2.58-alt-texinfo.patch
Patch2: autoconf-2.59-alt-datadir.patch
Patch3: autoconf-2.59-alt-warnings.patch
Patch4: autoconf-2.59-alt-_AC_PATH_X_XMKMF.patch
Patch5: autoconf-2.59-alt-AC_PROG_CXXCPP.patch
Patch6: autoconf-2.59-alt-AC_LANG_FUNC_LINK_TRY_GCC_BUILTIN.patch
Patch7: autoconf-2.59-rh-_AC_PATH_X_DIRECT.patch
Patch8: autoconf-2.59-owl-tmp.patch
Patch9: autoconf-2.59-alt-intltool.patch
Patch10: autoconf-2.59-alt-stubs.patch

Provides: %{realname}_2.5 = %EVR
Obsoletes: %{realname}_2.5

PreReq: autoconf-common
Requires: m4 >= 1.4, mktemp >= 1:1.3.1

BuildRequires: help2man, makeinfo

%description
GNU's Autoconf is a tool for configuring source code and Makefiles.
Using Autoconf, programmers can create portable and configurable
packages, since the person building the package is allowed to
specify various configuration options.

You should install Autoconf if you are developing software and you'd
like to use it to create shell scripts which will configure your
source code packages.  If you are installing Autoconf, you will also
need to install the GNU m4 package.

Note that the Autoconf package is not required for the end user who
may be configuring software with an Autoconf-generated script;
Autoconf is only required for the generation of the scripts, not
their use.

%prep
%setup -n %srcname
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1

find -type f -name \*.orig -delete -print

find -type f -print0 |
	xargs -r0 grep -FZl 'mawk gawk' -- |
	xargs -r0 %__subst 's/mawk gawk/gawk mawk/g' --

# patch texinfo file
%__subst '/@direntry/,/@end direntry/ { s/(%realname)/(%realname%suff)/g;s/\(\* [[:alnum:].]*\):/\1%suff:/g }' doc/%realname.texi

%build
export ac_cv_prog_EMACS=no
%configure --program-suffix=%suff
%make_build

%install
%makeinstall

# We don't want to include the standards.info stuff in the package,
# since it comes from binutils.
rm -f %buildroot%_infodir/standards*

# Some more helpful scripts.
rm -f %buildroot%_datadir/%realname/INSTALL
mv %buildroot%_datadir/%realname %buildroot%_datadir/%realname%suff

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mv %buildroot%_infodir/%realname.info %buildroot%_infodir/%realname%suff.info

for f in %buildroot%_bindir/*%suff; do
	ln -s "${f##*/}" "${f%%%suff}%dialect"
done

%define _perl_lib_path %perl_vendor_privlib:%_datadir/%realname%suff

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%_bindir/*
%_datadir/%realname%suff
%_man1dir/*
%_infodir/*.info*
%doc AUTHORS NEWS README TODO

%changelog
