%define realname automake
%define dialect _1.6
%define dialect_regex _1\.6
%define suff -1.6

Name: %realname%dialect
Version: 1.6.3
Release: alt10
Epoch: 1

%add_findreq_skiplist %_datadir/%realname%suff/config.guess
%set_compress_method xz
%define _perl_lib_path %perl_vendor_privlib:%_datadir/%realname%suff

Summary: A GNU tool for automatically creating Makefiles
License: GPL
Group: Development/Other
Url: http://www.gnu.org/software/automake/
Packager: Dmitry V. Levin <ldv@altlinux.org>
BuildArch: noarch

%define srcname %realname-%version

Source: ftp://ftp.gnu.org/gnu/%realname/%srcname.tar.bz2

Patch1: automake-1.6.1-alt-texinfo.patch
Patch2: automake-1.6.3-alt-aclocal_libtool.patch
Patch3: automake-1.6-cvs-pythondir.patch

PreReq: automake-common

BuildRequires: makeinfo

%description
Automake is a tool for automatically generating Makefiles compliant with the
GNU Coding Standards.

You should install Automake if you are developing software and would like to
use its capabilities of automatically generating GNU standard Makefiles.  If
you install Automake, you will also need to install GNU Autoconf package.

%prep
%setup -q -n %srcname
%patch1 -p1
%patch2 -p1
%patch3 -p1
xz -k9 ChangeLog NEWS TODO

%build
%set_autoconf_version 2.5
%configure
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall MAKEINFOFLAGS=--no-split

install -p -m644 %realname%suff.info %buildroot%_infodir/

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^/usr/share/aclocal(%dialect_regex)?/.+\.m4$
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_bindir/*%suff
%_datadir/aclocal%suff
%_datadir/%realname%suff
%_infodir/*.info*
%doc AUTHORS README THANKS ChangeLog.* NEWS.* TODO.*

%changelog
