# define suffix for easy backporing bird-2.x to stable branches as bird2 package
# for build as bird - use gear.specsubst.suffix %nil
# for build as bird2 - use gear.specsubst.suffix 2
# gear-create-tag -s suffix=%nil or gear-create-tag -s suffix=2
%define _suffix 2
%define _localstatedir %_var
%define protocols all

Name: bird%_suffix
Version: 2.15.1
Release: alt2
Summary: BIRD Internet Routing Daemon

Group: Networking/Other
License: GPLv2
URL: http://bird.network.cz

VCS: https://gitlab.nic.cz/labs/bird
Source: %name-%version.tar
Source1: bird.init
Source2: bird.service

%if 0%_suffix != 0
Conflicts: bird
%else
Obsoletes: bird2 < %EVR
Provides: bird2 = %EVR
%endif

BuildRequires: libreadline-devel libncurses-devel flex glibc-kernheaders OpenSP linuxdoc-tools

%description
BIRD is an Internet Routing Daemon designed to support all the routing
technology used in the today's Internet or planned to be used in near
future and to have a clean extensible architecture allowing new routing
protocols to be incorporated easily. Among other features, BIRD supports:

 * both IPv4 and IPv6 protocols
 * multiple routing tables
 * the Border Gateway Protocol (BGPv4)
 * the Routing Information Protocol (RIPv2)
 * the Open Shortest Path First protocol (OSPFv2)
 * a virtual protocol for exchange of routes between different routing
   tables on a single host
 * a command-line interface allowing on-line control and inspection of
   status of the daemon
 * soft reconfiguration (no need to use complex online commands to
   change the configuration, just edit the configuration file and notify
   BIRD to re-read it and it will smoothly switch itself to the new
   configuration, not disturbing routing protocols unless they are
   affected by the configuration changes)
 * a powerful language for route filtering

BIRD has been developed at the Faculty of Math and Physics, Charles
University, Prague, Czech Republic as a student project. It can be
freely distributed under the terms of the GNU General Public License.

%prep
%setup

%build
%autoreconf
%configure  --with-runtimedir=/run/bird \
	    --sysconfdir=%_sysconfdir/bird \
	    --with-protocols=%protocols \
	    #
%make_build all


%install
%makeinstall_std
install -d %buildroot%_localstatedir/lib/bird %buildroot%_tmpfilesdir  %buildroot%_sysconfdir/bird/bird.d
install -pD -m755 %SOURCE1 %buildroot%_initdir/bird
install -pD -m644 %SOURCE2 %buildroot%_unitdir/bird.service

# create temporary directory
mkdir -p %buildroot%_tmpfilesdir
cat > %buildroot%_tmpfilesdir/bird.conf << _EOF_
d /run/bird 0750 _bird _bird -
_EOF_

# add bird.d configuration directory
cat >> %buildroot%_sysconfdir/bird/bird.conf << _EOF_
include "/etc/bird/bird.d/*.conf";
_EOF_

%check
make test

%pre
%_sbindir/groupadd -r -f _bird 2> /dev/null ||:
%_sbindir/useradd -r -n -g _bird -d /var/lib/bird -s /dev/null -c "BIRD Routing Daemon System User" _bird 2> /dev/null ||:

%post
%post_service bird

%preun
%preun_service bird

%files
%doc NEWS README doc/bird.conf.example*
%_initdir/bird
%_unitdir/bird.service
%dir %_sysconfdir/bird
%dir %_sysconfdir/bird/bird.d
%config(noreplace) %_sysconfdir/bird/bird.conf
%_tmpfilesdir/bird.conf
%dir %attr(0750,_bird,_bird) %_localstatedir/lib/bird
%_sbindir/bird
%_sbindir/birdc
%_sbindir/birdcl

%changelog
