%define _unpackaged_files_terminate_build 1

Name: blender
Version: 2.83.4
Release: alt1

Summary: 3D modeling, animation, rendering and post-production
License: GPL-3.0-or-later
Group: Graphics
URL: https://www.blender.org

# git://git.blender.org/blender.git
Source: %name-%version.tar

# git submodules
# before updating submodules via script don't forget
# to update relative submodule paths into absolute ones
Source1: locale-%version.tar
Source2: addons-%version.tar
Source3: addons_contrib-%version.tar
Source4: tools-%version.tar

Patch11: 0001-blender_thumbnailer.patch
Patch12: 0002-install_in_usr_share.patch
Patch13: 0004-do_not_use_version_number_in_system_path.patch

Patch21: blender-2.66-alt-pcre.patch
Patch22: blender-2.77-alt-enable-localization.patch
Patch23: blender-2.77-alt-usertempdir.patch
Patch24: blender-2.80-alt-include-deduplication-check-skip.patch
Patch25: blender-2.80-alt-use-system-glog.patch
Patch26: blender-2.82-alt-link-fix.patch
Patch27: blender-2.83.1-alt-remove-python2-dependency.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: boost-filesystem-devel boost-locale-devel
BuildRequires: cmake gcc-c++
BuildRequires: libGLEW-devel libXi-devel
BuildRequires: libavdevice-devel libavformat-devel
BuildRequires: libfftw3-devel libjack-devel libopenal-devel libsndfile-devel
BuildRequires: libjpeg-devel pkgconfig(libopenjp2) libpng-devel libtiff-devel libpcre-devel libswscale-devel libxml2-devel
BuildRequires: liblzo2-devel
BuildRequires: libopenCOLLADA-devel >= 0-alt3
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: libopenimageio-devel
BuildRequires: libopencolorio-devel
BuildRequires: openexr-devel
BuildRequires: libpugixml-devel
BuildRequires: libglog-devel libgflags-devel eigen3-devel
BuildRequires: libXxf86vm-devel libXrender-devel
BuildRequires: tbb-devel
BuildRequires: libfreetype-devel
# Remove following dependency when libopenjpeg2.0-devel is fixed
BuildRequires: openjpeg-tools2.0

%add_python3_path %_datadir/%name/scripts
%add_python3_req_skip _bpy
%add_python3_req_skip _bpy_path
%add_python3_req_skip _cycles
%add_python3_req_skip _freestyle
%add_python3_req_skip bgl
%add_python3_req_skip blf
%add_python3_req_skip idprop.types
%add_python3_req_skip gpu
%add_python3_req_skip io_scene_gltf2.blender.com
%add_python3_req_skip io_scene_gltf2.blender.exp
%add_python3_req_skip io_scene_gltf2.io.com
%add_python3_req_skip io_scene_gltf2.io.exp
%add_python3_req_skip mathutils.bvhtree
%add_python3_req_skip mathutils.geometry
%add_python3_req_skip mathutils.noise
%add_python3_req_skip oscurart_tools.files
%add_python3_req_skip oscurart_tools.mesh
%add_python3_req_skip oscurart_tools.object
%add_python3_req_skip oscurart_tools.render

%py3_provides BPyMesh
%py3_provides Blender
%py3_provides bmesh
%py3_provides bpy
%py3_provides bpy.props
%py3_provides bpy.types
%py3_provides bpy.app.translations
%py3_provides bpy.app.handlers
%py3_provides bpy.app

Requires: libopenCOLLADA >= 0-alt3

Obsoletes: %name-i18n

%description
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation

%description -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

%prep
%setup -a 1 -a 2 -a 3 -a 4

# debian
%patch11 -p1
%patch12 -p1
%patch13 -p1

%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1

%ifnarch %ix86 x86_64
sed -i 's,-fuse-ld=gold,,' build_files/cmake/platform/platform_unix.cmake
%endif

# Delete the bundled FindOpenJPEG to make find_package use the system version
# instead (the local version hardcodes the openjpeg version so it is not update
# proof)
rm -f build_files/cmake/Modules/FindOpenJPEG.cmake

# Remove bundled libraries which must not be used instead of system ones
rm -rf extern/{Eigen3,glew,lzo,gflags,glog}

%build
BUILD_DATE="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%Y-%%m-%%d')"
BUILD_TIME="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%H:%%M:%%S')"

# needed due to non-standard location of pcre.h header
%add_optflags "-I%_includedir/pcre"

%add_optflags -fPIC -funsigned-char -fno-strict-aliasing

%cmake \
%ifnarch %{ix86} x86_64
	-DWITH_RAYOPTIMIZATION=OFF \
	-DWITH_CPU_SSE=OFF \
%endif
	-DBUILD_SHARED_LIBS=OFF \
	-DWITH_FFTW3=ON \
	-DWITH_JACK=ON \
	-DWITH_CODEC_SNDFILE=ON \
	-DWITH_IMAGE_OPENJPEG=ON \
	-DWITH_PYTHON=ON \
	-DWITH_PYTHON_INSTALL=OFF \
	-DWITH_CODEC_FFMPEG=ON \
	-DWITH_CXX_GUARDEDALLOC=OFF \
	-DWITH_INSTALL_PORTABLE=OFF \
	-DWITH_PYTHON_SAFETY=ON \
	-DWITH_OPENMP=OFF \
	-DWITH_OPENCOLLADA=ON \
	-DWITH_CYCLES=ON \
	-DWITH_OPENCOLORIO=ON \
	-DWITH_OPENIMAGEIO=ON \
	-DWITH_SYSTEM_GLEW=ON \
	-DWITH_SYSTEM_LZO=ON \
	-DWITH_SYSTEM_EIGEN3:BOOL=ON \
	-DWITH_SYSTEM_GFLAGS:BOOL=ON \
	-DWITH_SYSTEM_GLOG:BOOL=ON \
	-DWITH_IMAGE_OPENEXR=ON \
	-DWITH_TBB:BOOL=ON \
	-DWITH_USD:BOOL=ON \
	-DPYTHON_VERSION="%_python3_version" \
	-DBUILDINFO_OVERRIDE_DATE="$BUILD_DATE" \
	-DBUILDINFO_OVERRIDE_TIME="$BUILD_TIME" \
	-DWITH_DOC_MANPAGE:BOOL=ON \
	%nil

%cmake_build

%install
%cmakeinstall_std

mkdir -p %buildroot%_datadir/metainfo
install -m644 release/freedesktop/*.appdata.xml %buildroot%_datadir/metainfo/

%files
%_bindir/*
%_desktopdir/*
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_datadir/%name/
%_datadir/metainfo/*.appdata.xml
%_defaultdocdir/%name/
%_man1dir/*.1*

%changelog
