# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1

Name: blktrace
Version: 1.2.0
Release: alt1
Summary: Block queue IO tracer
License: GPL-2.0-only
Group: Development/Debuggers
Url: https://git.kernel.dk/cgit/blktrace/
Vcs: git://git.kernel.dk/blktrace.git

Source: %name-%version.tar
BuildRequires: libaio-devel

# Avoid: "forbidden requires: python-base
# sisyphus_check: check-deps ERROR: package dependencies violation"
AutoReqProv: nopython noshebang

%description
blktrace is a block layer IO tracing mechanism which provides detailed
information about request queue operations up to user space.

%prep
%setup

%build
%make_build CFLAGS="%optflags"
# No building docs to avoid bringing texlive monster.

%install
%makeinstall_std \
	prefix=%prefix \
	mandir=%_mandir

%check
%buildroot%_bindir/blkparse -V
%buildroot%_bindir/btreplay -V
%buildroot%_bindir/btrecord -V
%buildroot%_bindir/btt -V
%buildroot%_bindir/blkiomon -V
# blktrace itself will just segfault, becasue no access to `/sys/devices/system/cpu/online`.
# Other proggies do not support `-V`.

%files
%doc README doc/blktrace.tex
%_bindir/*
%_man1dir/*
%_man8dir/*

%changelog
