Name:		burp
Version:	2.3.22
Release:	alt1

Summary:	Burp is a network-based backup and restore program
License:	AGPL-3.0 and BSD and GPLv2+ and LGPLv2+
Group:		Archiving/Backup
Url:		https://burp.grke.org/

# https://github.com/grke/burp.git master
Source:		%{name}-%{version}.tar

BuildRequires:  libtool
BuildRequires:  librsync-devel
BuildRequires:  zlib-devel
BuildRequires:  openssl-devel
BuildRequires:  libncurses-devel
BuildRequires:  libacl-devel
BuildRequires:  libuthash-devel
BuildRequires:  libyajl-devel
BuildRequires:  check libcheck-devel
BuildRequires:  libcap-devel
BuildRequires:  openssl

BuildRequires: rpm-macros-intro-conflicts
%add_findreq_skiplist %_datadir/%name/scripts/*
%add_optflags -Wno-error=unused-variable

%description
Burp is a network backup and restore program, using client and server.
It uses librsync in order to save network traffic and to save on the
amount of space that is used by each backup.

%prep
%setup

%build
%autoreconf
%configure \
    --sysconfdir="%_sysconfdir/burp" \
    --disable-static

%make_build

%install
%makeinstall_std install-all
install -D -p -m 0755 .gear/burp.init %{buildroot}%{_initrddir}/burp-server
install -D -p -m 0644 .gear/burp.service %{buildroot}%{_unitdir}/burp-server.service
%__subst "s,password,#password,g" %{buildroot}%_sysconfdir/burp/clientconfdir/testclient

%check
%make_build check
.gear/test-burp.sh

%files
%doc %_docdir/%name/
%{_initrddir}/burp-server
%{_unitdir}/burp-*.*
%dir %_datadir/%name/
%_datadir/%name/scripts/
%_bindir/vss_strip
%_sbindir/*
%_man8dir/*
%defattr(640,root,_burp,3770)
%dir %_sysconfdir/burp/
%dir %_sysconfdir/burp/CA-client/
%dir %_sysconfdir/burp/clientconfdir/
%dir %_sysconfdir/burp/clientconfdir/incexc/
%config(noreplace) %_sysconfdir/burp/*.c*nf
%config(noreplace) %_sysconfdir/burp/clientconfdir/testclient
%config(noreplace) %_sysconfdir/burp/clientconfdir/incexc/example

%pre
/usr/sbin/groupadd -r -f _burp
/usr/sbin/useradd -r -g _burp -d /var/empty -s /dev/null -n -c "BURP BackUp and Restore Program" _burp >/dev/null 2>&1 ||:

%post
%post_service burp-server

%preun
%preun_service burp-server

%changelog
