# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_disable session
Name: cairo-dock
Version: 3.4.1
Release: alt6

Summary: A light and eye-candy dock to launch your programs easily
Summary(ru_RU.UTF-8): Приятный глазу док для простого запуска ваших программ
License: GPLv3+
Group: Graphical desktop/Other
# http://glx-dock.org
Url: https://launchpad.net/cairo-dock-core

Packager: Anton Midyukov <antohami@altlinux.org>
Source: %name-%version.tar
Source1: cairo-dock-16x16.png
Source2: cairo-dock-32x32.png
Source3: cairo-dock-48x48.png

Buildrequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: desktop-file-utils
BuildRequires: gcc-c++
BuildRequires: pkgconfig(gconf-2.0)
BuildRequires: pkgconfig(glu)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(librsvg-2.0)
BuildRequires: pkgconfig(libxml-2.0)

%if_enabled session
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xdmcp)
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xxf86vm)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(xinerama)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xkbcommon-x11)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(epoxy)
BuildRequires: pkgconfig(atk-bridge-2.0)
BuildRequires: pkgconfig(atspi-2)
%endif

Requires: %name-data = %EVR

%description
Cairo-dock uses cairo to render nice graphics, and Glitz to use hardware
acceleration. It's fully configurable and can be a taskbar too. You can
easily plug applets into it.

%description -l ru_RU.UTF-8
Сairo-dock использует cairo для рендеринга приятной графики и Glitz для
задействования аппаратного ускорения. Это полностью настраиваемая и
многофункциональная панель задач. Вы можете легко включить апплеты не ней.

%package data
Summary: Data files for %name
Group: Graphical desktop/Other
BuildArch: noarch

%description data
Data files for %name

%if_enabled session
%package session
Summary: Session for %name
Group: Graphical desktop/Other
BuildArch: noarch
Requires: %name = %EVR

%description session
Session for %name
%endif

%package devel
Summary: Development files for cairo-dock
Group: Development/Other
Requires: %name = %EVR

%description devel
cairo-dock uses cairo to render nice graphics, and Glitz to use hardware
acceleration. It's fully configurable and can be a taskbar too. You can
easily plug applets into it.

This package provides the include files and library for cairo-dock functions.

%prep
%setup -n %name-%version

%build
%cmake %{?_enable_session:-Denable-desktop-manager=ON}
%cmake_build

%install
%cmakeinstall_std

%find_lang %name

mkdir -p %buildroot{%_niconsdir,%_miconsdir,%_liconsdir}
install -m644 %SOURCE1 %buildroot%_miconsdir/%name.png
install -m644 %SOURCE2 %buildroot%_niconsdir/%name.png
install -m644 %SOURCE3 %buildroot%_liconsdir/%name.png
desktop-file-install --dir %buildroot%_desktopdir \
    --remove-category=System \
    --add-category="GNOME;GTK;Utility;X-Desktop" \
    %buildroot%_desktopdir/cairo-dock.desktop
desktop-file-install --dir %buildroot%_desktopdir \
    --remove-category=System \
    --add-category="GNOME;GTK;Utility;X-Desktop" \
    %buildroot%_desktopdir/cairo-dock-cairo.desktop

%files -f %name.lang
%_bindir/%name
%_libdir/*.so.*
%_libdir/%name

%files data
%_datadir/%name
%_desktopdir/*.desktop
%_pixmapsdir/*.svg
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%_man1dir/*.1.*

%if_enabled session
%files session
%_bindir/%name-session
%_datadir/gnome-session/sessions/cairo-dock.session
%exclude %_datadir/xsessions/cairo-dock.desktop
%endif

%files devel
%_includedir/%name
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
