# -*- coding: utf-8 -*-
Name: calibre
Version: 3.42.0
Release: alt1

Summary: A e-book library management application
Summary(ru_RU.UTF8): Программа для работы с личной электронной библиотекой

License: GPL
Group: File tools
Url: http://calibre-ebook.com/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# https://calibre-ebook.com/dist/src redirect to
# Source-url: http://download.calibre-ebook.com/%version/calibre-%version.tar.xz
Source: %name-%version.tar
Source1: calibre-mount-helper

Patch: calibre-no-update.patch
Patch1: calibre-0.8.55-alt-no-macmenu.patch

Requires: fonts-ttf-liberation
Requires: xkeyboard-config

BuildRequires(pre): rpm-build-intro >= 1.9.19

%add_python_req_skip win32serviceutil win32service win32event win32con win32com win32api win32gui winerror _winreg pywintypes pythoncom usbobserver

BuildRequires: chrpath
BuildRequires: /proc

BuildRequires: cmake gcc-c++ libX11-devel libXext-devel libXrender-devel libpng-devel libjpeg-devel libusb-devel libsqlite3-devel

# missed in the official list
BuildRequires: glib2-devel fontconfig-devel libfreetype-devel libssl-devel libudev-devel

BuildRequires: python >= 2.7.9
Requires: python >= 2.7.9

BuildRequires: python-modules-json python-modules-compiler python-modules-curses python-modules-encodings

BuildRequires: python-module-sip-devel >= 4.19.1
Requires: python-module-sip >= 4.19.1

# Checked 01.10.2017 with
# https://github.com/kovidgoyal/build-calibre/blob/master/scripts/sources.json
# calibre/bypy/sources.json

BuildRequires: qt5-base-devel-static >= 5.3.2
BuildRequires: python-module-PyQt5-devel
# >= 5.8
BuildRequires: xdg-utils >= 1.0.2

BuildRequires: libpoppler-qt5-devel >= 0.20.2
BuildRequires: libpoppler-devel >= 0.52
BuildRequires: libpodofo-devel >= 0.9.5
BuildRequires: libwmf-devel >= 0.2.8
# chmlib
BuildRequires: libchm-devel >= 0.40
BuildRequires: libicu-devel >= 5.6
BuildRequires: libmtp-devel >= 1.1.11

# with msgpack 0.4.x: TypeError: unpackb() got an unexpected keyword argument 'raw'
%py_use msgpack >= 0.5.6
%py_use html5-parser
%py_use mechanize
# TODO
# >= 0.3.5
%py_use lxml >= 3.8.0
%py_use dateutil >= 2.5.3
%py_use css-parser >= 1.0.4
%py_use dns >= 1.14.0

%py_use netifaces >= 0.10.5
%py_use psutil >= 4.3.0
#py_use apsw >= 3.13.0
# as in p8
%py_use apsw >= 3.8.0
%py_use dbus >= 1.2.4
BuildRequires: libdbus-devel >= 1.10.8
# pygments 2.1.3
# optipng 0.7.6
# mozjpeg 3.1
%py_use cssselect >= 0.7.1

# no need really
#py_use soupsieve >= 1.8
# bs4 >= 4.7.1
%py_use BeautifulSoup4 >= 4.6.3

BuildRequires: libmtdev-devel libts-devel libinput-devel libxkbcommon-devel

BuildRequires: zlib-devel bzlib-devel
BuildRequires: libexpat >= 2.2.4
BuildRequires: libffi-devel >= 3.2.1
#BuildRequires: nasm
BuildRequires: libwebp-devel >= 0.5.0
# iconv?
BuildRequires: libxml2-devel
# >= 2.9.5
BuildRequires: libxslt-devel
# >= 1.1.30
BuildRequires: libgpg-error-devel >= 1.22
BuildRequires: libgcrypt-devel >= 1.7.1
BuildRequires: libdbus-glib-devel >= 0.106

%py_use six >= 1.10.0
%py_use regex >= 2017.01.11
%py_use dukpy
# >= 0.3
%py_use chardet >= 3.0.3
%py_use pycrypto >= 2.6.1
# TODO jxrlib
# https://packages.debian.org/ru/source/sid/jxrlib
%py_use webencodings >= 0.5.1
%py_use html5lib >= 0.999999999
%py_use Pillow >= 3.2.0
# TODO qtwebkit
Requires: python-module-unrardll

%description
calibre is an e-book library manager. It can view, convert and catalog e-books
in most of the major e-book formats. It can also talk to e-book reader
devices. It can go out to the internet and fetch metadata for your books.
It can download newspapers and convert them into e-books for convenient
reading. It is cross platform, running on Linux, Windows and OS X.

%description -l ru_RU.UTF8
Calibre - свободная программа для создания и управления библиотекой электронных книг,.
которая работает в среде Linux, OSX и Windows. Calibre должна уметь делать все, что
необходимо для поддержки электронной библиотеки: работать с каталогом, преобразовывать.
форматы, загружать новости и адаптировать их для устройств чтения, а также.
синхронизировать коллекцию с устройствами для чтения.

Поддерживаемые форматы: MOBI, LIT, PRC, EPUB, ODT, HTML, CBR, CBZ, RTF,
TXT, PDF, LRS и FB2.

%prep
%setup -n %name
%__subst "s|libdir = s.get_python_lib.*|libdir = '%buildroot%python_sitelibdir'|" setup/install.py
# don't check for new upstream version
#patch -p1
#patch1 -p1

# TODO: assure we will not use it. see calibre-use-system-hunspell.patch
# rm -rf src/hunspell/

%build
%python_build

%install
#python_install (not use due skip-build unsupported)
mkdir -p %buildroot%python_sitelibdir/
python setup.py install --staging-libdir=%buildroot%_libdir --libdir=%_libdir --prefix=%_prefix --root=%buildroot --staging-root=%buildroot/%_prefix
%find_lang --with-kde %name

# fix bash completion file placement
install -m644 -D %buildroot%_datadir/bash-completion/completions/calibre %buildroot/etc/bash_completion.d/%name
rm -rf %buildroot%_datadir/bash-completion

chrpath -d %buildroot%_libdir/%name/%name/plugins/*.so

rm -f %buildroot%_bindir/calibre-uninstall
rm -rf %buildroot%_datadir/%name/fonts/liberation/
install -m 755 %SOURCE1 %buildroot%_bindir/calibre-mount-helper

%files -f %name.lang
%doc README.md Changelog.yaml
/etc/bash_completion.d/%name
%_bindir/*
%_libdir/%name/
%python_sitelibdir/*
%_datadir/%name/
# FIXME?
#_datadir/appdata/*.appdata.xml
%_datadir/metainfo/*.appdata.xml

%changelog
