%define _unpackaged_files_terminate_build 1

Name: ccache
Version: 3.4.2
Release: alt2
Summary: Compiler cache
License: GPLv3+
Group: Development/Tools
Url: http://ccache.samba.org/

Source: %name-%version.tar
Patch1: ccache-fedora-rounding.patch
Patch2: ccache-alt-version.patch

Provides: ccache3 = %version-%release
Obsoletes: ccache3

BuildRequires: asciidoc-a2x zlib-devel

%description
ccache is a compiler cache. It acts as a caching pre-processor to
C/C++ compilers, using the -E compiler switch and a hash to detect
when a compilation can be satisfied from cache. This often results in
a 5 to 10 times speedup in common compilations.

%prep
%setup
%patch1 -p1
%patch2 -p1
rm -rfv zlib/

sed -i -e "s:@VERSION@:%version:g" dev.mk.in

%build
%autoreconf
%configure
%make_build all docs

%install
%makeinstall

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/ignore.d
cat > %buildroot%_sysconfdir/buildreqs/packages/ignore.d/%name << EOF
%name
EOF

%files
%doc LICENSE.adoc README.md GPL-3.0.txt doc
%_man1dir/ccache.1*
%_bindir/ccache
%_sysconfdir/buildreqs/packages/ignore.d/*

%changelog
