# TODO: botocore

%def_with plugins
%def_without dns_route53

Name: certbot
Version: 1.5.0
Release: alt2

Summary: A free, automated certificate authority client

License: ASL 2.0
Group: Networking/Other
Url: https://certbot.eff.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# #Source-url: https://pypi.python.org/packages/source/l/%name/%name-%version.tar.gz
# Source-url: https://github.com/certbot/certbot/archive/v%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch
BuildRequires: python3-devel python3-module-setuptools
BuildRequires(pre): rpm-build-python3 rpm-build-intro

%define acme_version %version

Requires: python3-module-zope.component
Requires: python3-module-zope.interface >= 4.1.0
Requires: python3-module-pyasn1 >= 0.1.8
Requires: python3-module-cffi >= 1.4.2
# missed by autoreq
Requires: python3-module-future

#Provides: python-module-%name = %EVR
#Obsoletes: python-module-%name < %EVR

# Due Prior to Python 2.7.9 the stdlib SSL module did not allow a user to configure
# See /usr/lib/python2.7/site-packages/acme/client.py
#Requires: python-base >= 2.7.9

# Required for documentation
#BuildRequires: python-sphinx
#BuildRequires: python-sphinx_rtd_theme
#BuildRequires: python-repoze-sphinx-autointerface
#BuildRequires: python-sphinxcontrib-programoutput

%py3_use acme >= %acme_version
%py3_use cryptography >= 1.2.3
%py3_use distro >= 1.0.1
%py3_use josepy >= 1.1.0
%py3_use parsedatetime >= 1.3

Provides: letsencrypt = %version
Obsoletes: letsencrypt

%define certbotdir %_datadir/%name
#add_python_req_skip certbot
%py3_provides certbot

# https://lists.altlinux.org/pipermail/devel/2012-March/193598.html
# https://lists.altlinux.org/pipermail/devel/2019-October/208661.html
%add_python3_path %certbotdir
%allow_python3_import_path %certbotdir

#add_python3_lib_path %certbotdir/certbot_nginx
#add_python3_lib_path %certbotdir/certbot_apache
#add_python3_lib_path %certbotdir/certbot_dns-rfc2136
#add_python3_lib_path %certbotdir/certbot_dns-route53
#add_python3_lib_path %certbotdir/certbot_postfix

%description
Let's Encrypt is a free, automated certificate authority that aims
to lower the barriers to entry for encrypting all HTTP traffic on the internet.

# TODO: move to /usr/share/%name
%package -n python3-module-%name
Group: Networking/Other
Requires: python3-module-configargparse >= 0.10.0
# already in core python
#Requires: python-module-argparse
Requires: python3-module-psutil >= 2.1.0
Requires: python3-module-acme >= %acme_version
#Recommends: letsencrypt-doc
Summary: Python 3 libraries used by %name

Provides: python3-module-letsencrypt = %version
#Obsoletes: python-module-letsencrypt


%description -n python3-module-%name
The python2 libraries to interface with %name.

# TODO
%if_with plugins
%package apache
Group: Networking/Other
Summary: Certbot Apache plugin
AutoProv: no
Requires: %name = %EVR
# ALT bug 37004
Requires: python3-module-augeas

%description apache
Certbot Apache plugin.

%package nginx
Group: Networking/Other
Summary: Certbot nginx plugin
AutoProv: no
Requires: %name = %EVR

%description nginx
Certbot nginx plugin.

%package postfix
Group: Networking/Other
Summary: Certbot postfix plugin
AutoProv: no
Requires: %name = %EVR

%description postfix
Certbot postfix plugin.


%package dns_rfc2136
Group: Networking/Other
Summary: Certbot dns_rfc2136 plugin
AutoProv: no
Requires: %name = %EVR

%description dns_rfc2136
Certbot dns-rfc2136 plugin.

%package dns_route53
Group: Networking/Other
Summary: Certbot dns_route53 plugin
AutoProv: no
Requires: %name = %EVR

%description dns_route53
Certbot dns_route53 plugin.

%endif

%prep
%setup

%build
cd certbot
%python3_build

cd ../certbot-apache
%python3_build
cd ../certbot-nginx
%python3_build
#cd ../certbot-postfix
#python_build
cd ../certbot-dns-route53
%python3_build
cd ../certbot-dns-rfc2136
%python3_build


%install
cd certbot
%python3_install --install-purelib=%certbotdir

cd ../certbot-apache
%python3_install --install-purelib=%certbotdir
cd ../certbot-nginx
%python3_install --install-purelib=%certbotdir
#cd ../certbot-postfix
#python_install --install-purelib=%certbotdir
%if_with dns_route53
cd ../certbot-dns-route53
%python3_install --install-purelib=%certbotdir
%endif
cd ../certbot-dns-rfc2136
%python3_install --install-purelib=%certbotdir
cd -

# TODO: remove compat dirs
mkdir -p %buildroot%_sysconfdir/letsencrypt
ln -s letsencrypt %buildroot%_sysconfdir/%name
mkdir -p %buildroot%_sharedstatedir/letsencrypt
ln -s letsencrypt %buildroot%_sharedstatedir/%name
mkdir -p %buildroot%_logdir/letsencrypt
ln -s letsencrypt %buildroot%_logdir/%name

ln -s %name %buildroot%_bindir/letsencrypt

rm -rfv %buildroot%certbotdir/certbot*/tests/
rm -rfv %buildroot%certbotdir/certbot/*/*_test*
rm -rfv %buildroot%certbotdir/certbot/*_test*
rm -rfv %buildroot%certbotdir/*/*_test*
rm -rfv %buildroot%certbotdir/certbot/certbot_compatibility_test/

#  it is better do not require argparse on python >= 2.7.
#__subst "s|^argparse$||" %buildroot%python_sitelibdir/%name-%{version}*.egg-info/requires.txt

%__subst 's|^__requires__.*|\
# ALT: use own package dir\
import site\
site.addsitedir("%certbotdir")|' %buildroot%_bindir/%name

%check
#python_test

%files
%doc LICENSE.txt
%doc README.rst CHANGELOG.md CONTRIBUTING.md
%_bindir/%name
#%doc %attr(0644,root,root) %_man1dir/%{name}*
%dir %_sysconfdir/%name/
%dir %_sharedstatedir/%name/
%dir %_logdir/%name/
# compats
%_bindir/letsencrypt
%dir %_sysconfdir/letsencrypt/
%dir %_sharedstatedir/letsencrypt/
%dir %_logdir/letsencrypt/

#files -n python-module-%name
#doc LICENSE.txt
%dir %certbotdir/
%certbotdir/%name/
%certbotdir/%name-%{version}*.egg-info

%if_with plugins
%files nginx
%doc LICENSE.txt
%certbotdir/certbot_nginx/
%certbotdir/certbot_nginx-%{version}*.egg-info

%files apache
%doc LICENSE.txt
%certbotdir/certbot_apache/
%certbotdir/certbot_apache-%{version}*.egg-info

#files postfix
#doc LICENSE.txt
#certbotdir/certbot_postfix/
#certbotdir/certbot_postfix-*.egg-info

%files dns_rfc2136
%doc LICENSE.txt
%certbotdir/certbot_dns_rfc2136/
%certbotdir/certbot_dns_rfc2136-%{version}*.egg-info

%if_with dns_route53
%files dns_route53
%doc LICENSE.txt
%certbotdir/certbot_dns_route53/
%certbotdir/certbot_dns_route53-%{version}*.egg-info
%endif
%endif

%changelog
