%define _unpackaged_files_terminate_build 1
%define _libexecdir /usr/libexec
%define _localstatedir /var

%def_with check

Name: certmonger
Version: 0.79.11
Release: alt1
Summary: Certificate status monitor and PKI enrollment client

Group: System/Base
License: %gpl3plus
Url: https://pagure.io/certmonger
Source0: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires: libcurl-devel
BuildRequires: libdbus-devel
BuildRequires: libidn2-devel
BuildRequires: libkrb5-devel
BuildRequires: libldap-devel
BuildRequires: libnss-devel
BuildRequires: libpopt-devel
BuildRequires: libssl-devel
BuildRequires: libtalloc-devel
BuildRequires: libtevent-devel
BuildRequires: libxml2-devel
BuildRequires: libxmlrpc-devel
BuildRequires: libsystemd-devel

%if_with check
BuildRequires: /proc
BuildRequires: dbus-tools-gui
BuildRequires: dos2unix
BuildRequires: nss-utils
BuildRequires: openssl
BuildRequires: python3(dbus)
%endif

Requires: dbus

%description
Certmonger is a service which is primarily concerned with getting your
system enrolled with a certificate authority (CA) and keeping it enrolled.

%prep
%setup
%patch -p1
# writerand option is introduced in openssl 1.1.1
grep -qs 'openssl rand -writerand $$HOME/\.rnd;' tests/Makefile.am || exit 1
sed -i 's/openssl rand -writerand $$HOME\/\.rnd;/openssl rand -out $$HOME\/\.rnd 1024;/g' tests/Makefile.am

%build
%autoreconf
%configure \
        --disable-rpath \
	--enable-systemd \
	--enable-tmpfiles \
	--with-homedir=/run/certmonger \
	--with-tmpdir=/run/certmonger \
        --enable-pie \
        --enable-now

%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_sharedstatedir/%name/{cas,requests}
mkdir -p %buildroot%_tmpfilesdir
mv %buildroot/usr%_tmpfilesdir/%name.conf %buildroot%_tmpfilesdir/%name.conf
%find_lang %name

%check
%make check

%post
%post_service %name

%preun
%preun_service %name

%triggerpostun -- certmonger <= 0.79.7-alt1
# update certmonger helper paths for existing installations
# /usr/lib/certmonger/ => /usr/libexec/certmonger/
set -o errexit
set -o nounset
set -o pipefail

export LC_ALL=C

help () {
    printf -- 'Please, check and update certmonger CAs helpers manually\n' >&2
    exit 0
}

getcert refresh-ca -a >/dev/null 2>&1 || help
cas_list="$(getcert list-cas | grep -o "^CA '.*':" | cut -d\' -f2 | \
              tr '\n' ' ')" || \
         help

old_path=" /usr/lib/certmonger/"
new_path=" /usr/libexec/certmonger/"
helper=
modified_helper=
for ca in $cas_list; do
    # helper could be empty
    helper="$(getcert list-cas -c "$ca" | grep 'helper-location:' | \
                cut -d':' -f2)" || \
           continue
    if [ -z "$helper" -o -n "${helper##*$old_path*}" ]; then
        continue
    fi
    modified_helper="${helper//$old_path/$new_path}"
    # remove leading whitespace
    modified_helper="$(sed 's/^[[:space:]]*//' <<<"$modified_helper")"
    getcert modify-ca -c "$ca" -e "$modified_helper" || help
done
getcert refresh-ca -a >/dev/null 2>&1 || help

%files -f %name.lang
%doc README.md LICENSE STATUS doc/*.txt
%config(noreplace) %_sysconfdir/dbus-1/system.d/certmonger.conf
%config(noreplace) %_sysconfdir/certmonger/certmonger.conf
%attr(0644,root,root) %config(noreplace) %_tmpfilesdir/certmonger.conf
%_datadir/dbus-1/services/certmonger.service
%_datadir/dbus-1/system-services/org.fedorahosted.certmonger.service
%_unitdir/certmonger.service
%dir %_sysconfdir/certmonger
%_bindir/certmaster-getcert
%_bindir/getcert
%_bindir/ipa-getcert
%_bindir/local-getcert
%_bindir/selfsign-getcert
%_sbindir/certmonger
%dir %_libexecdir/certmonger
%_libexecdir/certmonger/certmaster-submit
%_libexecdir/certmonger/certmonger-session
%_libexecdir/certmonger/dogtag-ipa-renew-agent-submit
%_libexecdir/certmonger/dogtag-submit
%_libexecdir/certmonger/ipa-submit
%_libexecdir/certmonger/local-submit
%_libexecdir/certmonger/scep-submit
%dir %_sharedstatedir/certmonger
%_sharedstatedir/certmonger/cas/
%_sharedstatedir/certmonger/local/
%_sharedstatedir/certmonger/requests/
%_man1dir/certmaster-getcert.1.*
%_man1dir/getcert-*.1.*
%_man1dir/getcert.1.*
%_man1dir/ipa-getcert.1.*
%_man1dir/local-getcert.1.*
%_man1dir/selfsign-getcert.1.*
%_man5dir/certmonger.conf.5.*
%_man8dir/certmonger-*.8.*
%_man8dir/certmonger.8.*

%changelog
