%define _unpackaged_files_terminate_build 1

%def_with	milter
%def_without	llvm
%def_with	systemd

%def_with ownconfdir

%if_with ownconfdir
%define clamconfdir /etc/clamav
%else
%define clamconfdir /etc
%endif

%define rctag %nil

Name: clamav
Version: 0.103.12
Release: alt1
%define abiversion 9

Summary: Clam Antivirus scanner
License: GPL-2.0-only with exeptions
Group: File tools

URL: http://www.clamav.net/
%ifdef snap
Source0: http://www.clamav.net/snapshot/clamav-devel-%snap.tar.gz
%else
Source0: http://downloads.sourceforge.net/clamav/clamav-%{version}%{rctag}.tar.gz
%endif

Source1: clamav.init
Source2: clamonacc.init
Source3: clamav.sysconfig

Source4: freshclam.cron
Source5: freshclam.logrotate
Source6: clamav.logrotate
Source7: clamav.tmpfiles

Source10: clamav-milter.init
Source11: clamav-milter.sysconfig
Source12: clamav-milter.msg
Source13: clamav-milter.whitelist
Source14: clamav-milter.conf
Source15: clamav-milter.service

Source20: virusstat-perIP
Source21: virusstat-perIP-PrevHour
Source22: virusstat-total
Source23: virusstat.cron.example

Patch1: clamav-config.patch
Patch2: freshclam-config.patch
Patch3: clamav-config-systemd.patch

Patch20: clamav-0.99-pkgconfig.patch
Patch21: clamav-AC_SYS_LARGEFILE.patch

# Package with clamd should require libclamav, not vice versa.
# Corresponding libclamav version need to be updated before, or clamd restart may fail!
Requires: lib%{name} = %version-%release

# Database updater moved to separated package.
Requires: clamav-freshclam = %version-%release

# postinstall uses subst utility
Requires(post): sed >= 1:3.02-alt1

# sed used by configure script
BuildRequires: sed

# is needed since 0.101 even without llvm
BuildRequires: gcc-c++

BuildRequires: bzlib-devel libcheck-devel libncurses-devel zlib-devel libssl-devel libxml2-devel libpcre2-devel
BuildRequires: git-core graphviz groff-extra gv zip doxygen flex

# for clamsubmit
BuildRequires: libcurl-devel libjson-c-devel

%{?_with_llvm:BuildRequires: llvm-devel }

%{?_with_milter:BuildRequires: sendmail-devel}

%{?_with_systemd:BuildRequires: libsystemd-devel}

# for snapshots
%{?snap: BuildRequires: automake}

%description
Clam AntiVirus is an anti-virus toolkit for Unix. The main purpose of this
software is the integration with mail servers (attachment scanning). The
package provides a flexible and scalable multi-threaded daemon, a commandline
scanner, and a tool for automatic updating via Internet. The programs are
based on a shared library distributed with the Clam AntiVirus package, which
you can use in your own software.

Some parts of code have separate licenses. See %_defaultdocdir/%name-%version

%package -n lib%{name}%{abiversion}
Summary: Shared libraries for clamav
Group: System/Libraries
Provides: lib%name = %version-%release

# https://lists.clamav.net/pipermail/clamav-devel/2019-January/000443.html
Conflicts: libclamav7 < 0.100.2-alt3

%description -n lib%{name}%{abiversion}
Shared libraries for clamav.

%package -n lib%{name}-devel
Summary: Development header files and libraries for clamav
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%{name}-devel
This package contains the development header files and libraries
necessary to develop clamav client applications.

%if_with milter
%package milter
Summary: clamav-milter for sendmail
Group: File tools
Requires: clamav = %version, /usr/sbin/sendmail

%description milter
This package contains the filter for Sendmail necessary to
integrate clamav with Sendmail MTA.
%endif

%package manual
Summary: ClamAV User Manual
Group: Books/Howtos
BuildArch: noarch

%description manual
This package contains user manual for ClamAV in Markdown and HTML formats.

%package freshclam
Summary: Auto-updater for the Clam Antivirus scanner virus signature files
Group: File tools

%description freshclam
This package contains programs which can be used to update the clamav anti-virus
database automatically. It uses the freshclam(1) utility for this task.

%package clamonacc
Summary: Clam On-Access Scanner daemon
Requires: %name = %version-%release
Group: File tools

%description clamonacc
This package contains Clam On-Access Scanner daemon. Look to clamonacc(8)
for details.

%prep
%setup %{?snap: -n clamav-devel-%snap} %{?rctag: -n clamav-%{version}%{rctag}}
%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch20 -p1
%patch21 -p0

%build
# fixed RPATH issue (0.97.3 tarball built with wrong libtool)
%{!?snap: aclocal --force -I m4}
%{!?snap: %autoreconf}

%add_optflags -std=gnu++11

# gcc 14.2.1
%add_optflags -Wno-error=incompatible-pointer-types

# --disable-clamav: Disable test for clamav user/group
%configure \
	--sysconfdir=%clamconfdir \
	--enable-experimental \
	--enable-clamdtop \
	--disable-clamav \
	--with-user=mail \
	--with-group=mail \
	--with-dbdir=/var/lib/%name \
	%{?_without_llvm: --disable-llvm} \
	%{?_with_milter: --enable-milter} \
#

# Safety belt for IPv6 enabling. We want to build clamav with IPv6 support,
# but can not rely on configure check as it can fail if build host set up
# as IPv4 only system.
echo >> clamav-config.h
echo "#ifndef SUPPORT_IPv6" >> clamav-config.h
echo "#define SUPPORT_IPv6 1" >> clamav-config.h
echo "#endif" >> clamav-config.h

# needed for 0.99.1
sed "s|pcre\.h|pcre/pcre.h|" -i libclamav/regex_pcre.h  # include <pcre.h>

%make_build

install -m644 %_sourcedir/virusstat* .

%check

%make check

%install
%makeinstall_std

mv %buildroot%clamconfdir/clamd.conf.sample %buildroot%clamconfdir/clamd.conf
mv %buildroot%clamconfdir/freshclam.conf.sample %buildroot%clamconfdir/freshclam.conf

%{!?_with_milter:rm -f %buildroot%_man1dir/clamav-milter*}

mkdir -p %buildroot/etc/rc.d/init.d
sed "s|@clamconfdir@|%clamconfdir|" < %_sourcedir/clamav.init > %buildroot/etc/rc.d/init.d/clamd
sed "s|@clamconfdir@|%clamconfdir|" < %_sourcedir/clamonacc.init > %buildroot/etc/rc.d/init.d/clamonacc

install -pD %_sourcedir/clamav.sysconfig %buildroot/etc/sysconfig/clamd
install -pD -m 644 %_sourcedir/clamav.tmpfiles %buildroot%_tmpfilesdir/clamav.conf

%if_with milter
sed -e 's|@@CLAMAVCONFDIR@@|%clamconfdir|' < %_sourcedir/clamav-milter.sysconfig > %buildroot/etc/sysconfig/clamav-milter
install -m644 %_sourcedir/clamav-milter.conf %buildroot%clamconfdir/
rm -f %buildroot%clamconfdir/clamav-milter.conf.sample
install -m755 %_sourcedir/clamav-milter.init %buildroot/etc/rc.d/init.d/clamav-milter
install -m644 %_sourcedir/clamav-milter.service %buildroot%_unitdir/clamav-milter.service
#install -m644 %_sourcedir/clamav-milter.whitelist %buildroot%clamconfdir/
#install -m644 %_sourcedir/clamav-milter.msg %buildroot%clamconfdir/
%endif

install -d %buildroot%_logdir/clamav
touch %buildroot%_logdir/clamav/clamd.log
touch %buildroot%_logdir/clamav/freshclam.log

# install the logrotate stuff
install -pD -m644 %_sourcedir/freshclam.logrotate %buildroot%_sysconfdir/logrotate.d/freshclam
install -m644 %_sourcedir/clamav.logrotate %buildroot%_sysconfdir/logrotate.d/clamav

# pid file dir
install -d %buildroot/var/run/clamav

# install docs (Markdown and HTML)
mkdir -p %buildroot%_defaultdocdir/clamav-manual/UserManual-html
cp -R docs/html/*       %buildroot%_defaultdocdir/clamav-manual/UserManual-html

# remove non-packaged files
rm -f %buildroot%_libdir/*.la
rm -f %buildroot%_libdir/*.a
# databases is not installing in 0.97.5
if [ -d %buildroot/var/lib/clamav ] ; then
    rm -f %buildroot/var/lib/clamav/*.cvd
else
    mkdir -p %buildroot/var/lib/clamav
fi


install -d %buildroot%_sysconfdir/cron.d
cat <<EOF >%buildroot%_sysconfdir/cron.d/clamav-freshclam
30 * * * *       root    %_bindir/freshclam --quiet --daemon-notify
EOF

%if_without milter
rm -f %buildroot/%_man8dir/clamav-milter.*
%endif

%if_with systemd
sed -i "s|@APP_CONFIG_DIRECTORY@|%clamconfdir|" %buildroot%_unitdir/clamav-clamonacc.service
# Aliases for systemd
ln -s clamav-daemon.service %buildroot%_unitdir/clamd.service
ln -s clamav-clamonacc.service %buildroot%_unitdir/clamonacc.service
%endif

%pre
# SubmitDetectionStats removed in 0.100
subst "s/^SubmitDetectionStats/# SubmitDetectionStats/" %_sysconfdir/clamav/freshclam.conf

%post
## Format of database changing occasionally. So removing database.
#for FNAME in `ls --ignore=*.socket /var/lib/clamav`; do
#    [ -h /var/lib/clamav/$FNAME ] && continue
#    [ -d /var/lib/clamav/$FNAME ] && rm -rf /var/lib/clamav/$FNAME
#    [ -f /var/lib/clamav/$FNAME ] && rm -f /var/lib/clamav/$FNAME
#done

%post_service clamd

%post freshclam
# randomize time of database updating (in order to distribute load on servers evenly)
RNDM=$[$RANDOM/555]
subst "s/^[0-9]*/$RNDM/" %_sysconfdir/cron.d/clamav-freshclam

%preun
%preun_service clamd

%if_with milter
%post milter
%post_service clamav-milter

%preun milter
%preun_service clamav-milter
%endif

%files
%doc virusstat*
%doc COPYING COPYING.* README.md

%_bindir/clamdscan
%_bindir/clamscan
%_bindir/clamsubmit
%_bindir/sigtool
%_bindir/clamdtop
%_bindir/clambc
%_sbindir/clamd
%attr(0755,root,root) %config %_initdir/clamd
%{?_with_ownconfdir: %dir %clamconfdir}
%config(noreplace) %verify(not md5 size mtime) %clamconfdir/clamd.conf
%config(noreplace) %_sysconfdir/logrotate.d/clamav
%attr(640,root,root) %config(noreplace) %verify(not md5 size mtime) /etc/sysconfig/clamd
%_tmpfilesdir/clamav.conf
%_man1dir/clamdscan*
%_man1dir/clamscan*
%_man1dir/clamsubmit*
%_man1dir/sigtool*
%_man1dir/clamdtop*
%_man1dir/clambc*
%_man5dir/*
%_man8dir/clamd*
%attr(3775,root,mail) %dir /var/lib/clamav
%attr(3775,root,mail) %ghost %dir /var/run/clamav
%attr(3771,root,mail) %dir %_logdir/clamav
%attr(640,mail,root) %ghost %_logdir/clamav/clamd.log

%if_with systemd
%_unitdir/clamav-daemon.*
%_unitdir/clamd.service
%endif

%files -n lib%{name}%{abiversion}
%_libdir/lib*.so.%abiversion
%_libdir/lib*.so.%abiversion.*
%_libdir/libclammspack.so.*
%_libdir/libfreshclam.so.*

%files freshclam
%{?_with_ownconfdir: %dir %clamconfdir}
%attr(3775,root,mail) %dir /var/lib/clamav
%attr(3775,root,mail) %ghost %dir /var/run/clamav
%attr(3771,root,mail) %dir %_logdir/clamav
%_bindir/freshclam
%_man1dir/freshclam*
%_bindir/clamconf
%_man1dir/clamconf*
%config(noreplace) %verify(not md5 size mtime) %clamconfdir/freshclam.conf
%config(noreplace) %_sysconfdir/cron.d/clamav-freshclam
%config(noreplace) %_sysconfdir/logrotate.d/freshclam
%attr(644,mail,mail) %ghost %_logdir/clamav/freshclam.log

%if_with systemd
# If %_sysconfdir/cron.d/clamav-freshclam packaged, then the clamav-freshclam.service not started
%exclude %_unitdir/clamav-freshclam.service
%_unitdir/clamav-freshclam-update.service
%endif

%files clamonacc
%_sbindir/clamonacc
%attr(0755,root,root) %config %_initdir/clamonacc
%_man8dir/clamonacc*

%if_with systemd
%_unitdir/clamav-clamonacc.*
%_unitdir/clamonacc.service
%endif

%files -n lib%{name}-devel
%_bindir/clamav-config
%_libdir/lib*.so
%_libdir/pkgconfig/*
%_includedir/*.h

%files manual
%_defaultdocdir/clamav-manual

%if_with milter
%files milter
%_sbindir/clamav-milter
%config %_initdir/clamav-milter
%config(noreplace) %verify(not md5 size mtime) /etc/sysconfig/clamav-milter
%config(noreplace) %verify(not md5 size mtime) %clamconfdir/clamav-milter.conf
%_man8dir/clamav-milter.*
#config(noreplace) #verify(not md5 size mtime) %clamconfdir/clamav-milter.whitelist
#config(noreplace) #verify(not md5 size mtime) %clamconfdir/*.msg

%if_with systemd
%_unitdir/clamav-milter.service
%endif

%endif

%changelog
