%def_disable check

Name:    cloud-init
Version: 20.1
Release: alt3

Summary: Cloud instance init scripts
Group:   System/Configuration/Boot and Init
License: GPLv3
Url:     http://launchpad.net/cloud-init

Source0: %name-%version.tar

Source1: cloud-init-alt.cfg
Source2: 01_netplan.cfg
Source3: cloud-init-tmpfiles.conf

Source11: cloud-config
Source12: cloud-final
Source13: cloud-init
Source14: cloud-init-local

Patch1: %name-%version-%release.patch

%add_findreq_skiplist /lib/systemd/system-generators/cloud-init-generator

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-distribute python3-module-nose python3-module-mocker
BuildRequires: python3-module-yaml python3-module-oauthlib
BuildRequires: systemd-devel
BuildRequires: python3-module-httpretty python3-module-serial iproute2
BuildRequires: util-linux net-tools python3-module-jinja2
BuildRequires: python3-module-contextlib2 python3-module-prettytable
%if_enabled check
BuildRequires: /proc
BuildRequires: python3-module-requests python3-module-jsonpatch
BuildRequires: python3-module-configobj python3-module-mock
BuildRequires: python3-module-oauthlib rpm-build-vm
%endif

Requires: sudo
Requires: e2fsprogs
Requires: cloud-utils-growpart
Requires: procps
Requires: iproute net-tools
Requires: shadow-utils
Requires: /bin/run-parts
Requires: netplan
Requires: dhcp-client
# add not autoreq'ed
%py3_requires Cheetah
%py3_requires jinja2

# use urllib3 for requests.packages.urllib3
%py3_requires urllib3
%filter_from_requires /python3(requests.packages.urllib3.connection)/d
%filter_from_requires /python3(requests.packages.urllib3.poolmanager)/d

%description
Cloud-init is a set of init scripts for cloud instances.  Cloud instances
need special scripts to run during initialization to retrieve and install
ssh keys and to let the user run various scripts.

%package config-netplan
Summary: Cloud config option use netplan network render
Group:   System/Configuration/Boot and Init
License: GPLv3

%description config-netplan
%summary.

%prep
%setup
%patch1 -p1

%build
%python3_build_debug

%install
%python3_install --init-system=systemd

install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/cloud/cloud.cfg
install -pD -m644 %SOURCE2 %buildroot%_sysconfdir/cloud/cloud.cfg.d/
install -pD -m644 %SOURCE3 %buildroot%_tmpfilesdir/cloud-init.conf
install -pD -m755 %SOURCE11 %buildroot%_initdir/cloud-config
install -pD -m755 %SOURCE12 %buildroot%_initdir/cloud-final
install -pD -m755 %SOURCE13 %buildroot%_initdir/cloud-init
install -pD -m755 %SOURCE14 %buildroot%_initdir/cloud-init-local

mkdir -p %buildroot%_libexecdir
mv %buildroot/usr/libexec/%name %buildroot%_libexecdir/
mkdir -p %buildroot%_sharedstatedir/cloud

# Remove non-ALTLinux templates
rm -f %buildroot%_sysconfdir/cloud/templates/*.debian.*
rm -f %buildroot%_sysconfdir/cloud/templates/*.freebsd.*
rm -f %buildroot%_sysconfdir/cloud/templates/*.redhat.*
rm -f %buildroot%_sysconfdir/cloud/templates/*.suse.*
rm -f %buildroot%_sysconfdir/cloud/templates/*.ubuntu.*

%check
if [ -w /dev/kvm ]; then
    vm-run make unittest3
fi

%post
%post_service cloud-config
%post_service cloud-final
%post_service cloud-init
%post_service cloud-init-local

%preun
%preun_service cloud-config
%preun_service cloud-final
%preun_service cloud-init
%preun_service cloud-init-local

%files config-netplan
%config            %_sysconfdir/cloud/cloud.cfg.d/01_netplan.cfg

%files
%doc ChangeLog TODO.rst
%dir               %_sysconfdir/cloud
%config(noreplace) %_sysconfdir/cloud/cloud.cfg
%dir               %_sysconfdir/cloud/cloud.cfg.d
%config(noreplace) %_sysconfdir/cloud/cloud.cfg.d/*.cfg
%exclude           %_sysconfdir/cloud/cloud.cfg.d/01_netplan.cfg
%doc               %_sysconfdir/cloud/cloud.cfg.d/README
%dir               %_sysconfdir/cloud/templates
%config(noreplace) %_sysconfdir/cloud/templates/*
%_sysconfdir/NetworkManager/dispatcher.d/hook-network-manager
%_datadir/bash-completion/completions/%name
/lib/udev/rules.d/66-azure-ephemeral.rules
%_initdir/*
%_unitdir/*
%_tmpfilesdir/*
/lib/systemd/system-generators/cloud-init-generator
%python3_sitelibdir/*
%_libexecdir/%name
%_bindir/cloud-init*
%_bindir/cloud-id
%doc %_datadir/doc/%name
%dir %_sharedstatedir/cloud

%changelog
