Name: common-licenses
Version: 1.10
Release: alt1

Summary: Contains the various common licenses used in the %distribution
License: distributable
Group: System/Base
BuildArch: noarch
Packager: Dmitry V. Levin <ldv@altlinux.org>
Prefix: %prefix

Source: license.tar

%description
Contains the various common licenses uses by the %distribution.
Instead of including the COPYING file in every package,
just refer to this one.

%prep
%setup -q -n license

%build
if find license license-ambiguous -mindepth 1 -maxdepth 1 -printf '%%f\n' | sort | uniq -d | grep ^; then
	echo >&2 'These licenses are listed in both directories simultaneously.'
	exit 1
fi

if find license -mindepth 1 -maxdepth 1 -name '*-with-*-exception' |grep ^; then
	echo >&2 'License exceptions should be in the license-exception directory.'
	exit 1
fi

%install
mkdir -p \
	%buildroot%_licensedir \
	%buildroot%_licensedir-ambiguous \
	%buildroot%_licensedir-exception

cp -dp license/* %buildroot%_licensedir
cp -dp license-ambiguous/.desc %buildroot%_licensedir-ambiguous
cp -dp license-ambiguous/* %buildroot%_licensedir-ambiguous
cp -dp license-exception/* %buildroot%_licensedir-exception

%files
%_licensedir
%_licensedir-ambiguous
%_licensedir-exception

%changelog
