Name: coreutils
Version: 8.31.0.3.6bd78
Release: alt2
%define srcname %name-%version-%release

Summary: The GNU versions of common management utilities
License: GPLv3+
Group: System/Base
Url: https://www.gnu.org/software/coreutils/

# git://git.sv.gnu.org/coreutils refs/heads/master
# git://git.altlinux.org/people/ldv/packages/coreutils refs/heads/coreutils-current
Source0: %srcname.tar
# translationproject.org::tp/latest/coreutils/
# git://git.altlinux.org/people/ldv/packages/coreutils refs/heads/po-current
Source1: po-%version-%release.tar

# sources from fileutils
Source11: color_ls.sh
Source12: color_ls.csh

# sources from sh-utils
Source20: exit.c
Source21: getuseruid.c
Source23: runas.c
Source24: runbg.c
Source25: usleep.c
Source26: runas.1
Source27: usleep.1
Source28: true.1
Source29: false.1

# git://git.altlinux.org/people/ldv/packages/coreutils coreutils-current..coreutils-alt
Patch: %srcname.patch

%def_enable selinux

Provides: stat = %version, fileutils = %version, textutils = %version, sh-utils = %version
Provides: mktemp = 0:1.6, mktemp = 1:1.5-alt2
Obsoletes: stat, fileutils, textutils, sh-utils, mktemp
Conflicts: man-pages < 0:1.52-alt2, initscripts < 0:5.49-ipl41mdk, rpm-build < 0:4.0.4-alt7
# due to /bin/arch
Conflicts: util-linux < 0:2.13-alt6
# due to /usr/bin/kill and %_man1dir/kill.1
Conflicts: procps < 0:2.0.10-alt4
# due to incompatible change in "readlink -f"
Conflicts: chrooted < 0:0.3.1-alt1
# due to buggy rpmdups/rpmrdups
Conflicts: rpm-utils < 0:0.7.6-alt1
# due to hostname
Conflicts: net-tools < 0:1.60-alt9

BuildRequires: gnulib >= 0.1.2433.3043e
BuildRequires: makeinfo

# for ACL support in ls/dir/vdir, cp, mv and install utilities
BuildRequires: libacl-devel

# for extended attribute copying support in cp and mv utilities
BuildRequires: libattr-devel

# for colorizing capabilities support in ls utility
BuildRequires: libcap-devel

# for arbitrarily large numbers support in expr and factor utilities
BuildRequires: libgmp-devel

# due to build from git
BuildRequires: gperf

# due to ls
BuildRequires: libtinfo-devel

# due to exit.c
BuildRequires: glibc-devel-static

# for SELinux
%{?_enable_selinux:BuildRequires: libselinux-devel}

# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: strace}}

%description
These are the GNU core utilities.  This package is the union of
the GNU fileutils, sh-utils, and textutils packages.

These tools are the GNU versions of common useful and popular
file and text utilities which are used for:
+ file management
+ shell scripting
+ modifying text file

Most of these programs have significant advantages over their Unix
counterparts, such as greater speed, additional options, and fewer
arbitrary limits.

%prep
%setup -n %srcname -a1
%patch -p1

# Build scripts expect to find coreutils version in this file.
echo -n %version >.tarball-version

# Generate LINGUAS file.
ls po/*.po 2>/dev/null |
	sed 's|.*/||; s|\.po$||' >po/LINGUAS

# Compress docs for packaging.
bzip2 -9k NEWS THANKS

# workarounds for bootstrap
ln -s /bin/false build-aux/git-version-gen
touch m4/cu-progs.m4

%build
./bootstrap --skip-po --gnulib-srcdir=%_datadir/gnulib

# Disable printf_safe for a while,
# required to enforce build with system vfprintf().
sed -i 's/gl_printf_safe=yes/gl_printf_safe=/' m4/gnulib-comp.m4 configure

%configure \
	--exec-prefix=/ \
	%{subst_enable selinux} \
	--enable-install-program=arch,hostname \
	--enable-no-install-program=su,uptime \
	#

%make_build -C po update-po
%make_build

# Build our version of true and false.
build_exit() {
	%__cc %optflags -W %_sourcedir/exit.c \
		$@ -DSTATUS=0 -o true

	%__cc %optflags -W %_sourcedir/exit.c \
		$@ -DSTATUS=1 -o false
}

# Executable may fail on some architectures if it uses libc's syscall wrapper
# without initialization performed in start files.  Fall back to simple static
# true/false implementation if it happens.
build_exit -U_FORTIFY_SOURCE -fno-stack-protector -nostartfiles -static -DNOSTARTFILES=1
./true ||
	build_exit -static

# Build additional utilities.
for n in getuseruid runas runbg usleep; do
	%__cc %optflags "%_sourcedir/$n.c" -o $n
done

%install
%makeinstall_std
install -pD -m644 src/dircolors.hin "%buildroot%_sysconfdir/DIR_COLORS"

pushd "%buildroot"
	mkdir -p bin
	
	# %_bindir -> /bin relocations
        for n in \
		basename cat chgrp chmod chown cp cut date \
		dd df du echo false head hostname install \
		kill link ln ls mkdir mkfifo mknod mktemp \
		mv nice pwd readlink rm rmdir sleep sort \
		stty sync tail touch true uname unlink wc \
	; do
		mv .%_bindir/$n bin/
	done

	# compatibility symlinks
	for n in cat cut du head install kill mkfifo sort tail wc; do
		ln -s ../../bin/$n .%_bindir/
	done

	# chroot
	mkdir -p sbin .%_sbindir
	mv .%_bindir/chroot sbin/
		ln -s ../../sbin/chroot .%_sbindir/

	# hostname
	for n in dnsdomainname domainname nisdomainname ypdomainname; do
		ln -s hostname ./bin/$n
		ln -s hostname.1 ./%_man1dir/$n.1
	done

	mkdir -p .%_sysconfdir/profile.d
	install -pm755 %_sourcedir/color_ls.{sh,csh} .%_sysconfdir/profile.d/
	ln -s ../../bin/install .%_bindir/ginstall
popd

# Install assembler versions of true and false and their manpages.
install -pm755 true false %buildroot/bin/
install -pm644 %_sourcedir/{true,false}.1 %buildroot%_mandir/man1/

# Install additional utilities and their manpages.
install -pm755 getuseruid runas usleep %buildroot/bin/
install -pm755 runbg %buildroot%_bindir/
install -pm644 %_sourcedir/{runas,usleep}.1 %buildroot%_man1dir/

%find_lang %name

%check
: ${SHELL:=/bin/sh} ${VERBOSE:=no}
export SHELL VERBOSE
%make_build -k check

%files -f %name.lang
%config(noreplace) %_sysconfdir/DIR_COLORS
%config(noreplace) %_sysconfdir/profile.d/*
/bin/*
%_bindir/*
/sbin/*
%_sbindir/*
%_libexecdir/%name/
%_man1dir/*
%_infodir/*.info*
%doc AUTHORS NEWS.bz2 README THANKS.bz2 TODO

%changelog
