Name: cpio
Version: 2.12
Release: alt1

Summary: A GNU archiving program
License: GPLv3+
Group: Archiving/Backup
Url: http://www.gnu.org/software/cpio/

# ftp://ftp.gnu.org/gnu/cpio/cpio-%version.tar.bz2
Source: cpio-%version.tar
Patch: cpio-%version-%release.patch

BuildPreReq: makeinfo
# Due to static subpackage.
BuildPreReq: glibc-devel-static

Summary(ru_RU.UTF-8): Утилита архивации и копирования данных GNU cpio

%package static
Summary: Static version of the GNU cpio
Group: Archiving/Backup
Requires: %name = %version-%release
Summary(ru_RU.UTF-8): Статически скомпонованная версия архиватора GNU cpio

%description
GNU cpio copies files into or out of a cpio or tar archive.  Archives
are files which contain a collection of other files plus information
about them, such as their file name, owner, timestamps, and access
permissions.  The archive can be another file on the disk, a magnetic
tape, or a pipe.  GNU cpio supports the following archive formats:  binary,
old ASCII, new ASCII, crc, HPUX binary, HPUX old ASCII, old tar and POSIX.1
tar.  By default, cpio creates binary format archives, so that they are
compatible with older cpio programs.  When it is extracting files from
archives, cpio automatically recognizes which kind of archive it is reading
and can read archives created on machines with a different byte-order.

%description -l ru_RU.UTF-8
GNU cpio помещает и извлекает файлы из архивов формата TAR и CPIO.
Архивами в Юниксе принято называть файлы, хранящие коллекции других файлов
(необязательно сжатую - этим отдельно занимаются программы компрессии),
плюс некоторую дополнительную информацию о них: имена, идентификаторы
владельца и группы, время создания и изменения, права доступа и т.д.
Архив может храниться в файле на диске, на магнитной ленте, или записан
в канал (pipe) для обработки другой программой. GNU cpio поддерживает
следующие форматы архивов: двоичный, старый ASCII, новый ASCII, crc,
двоичный HPUX, старый ASCII HPUX, старый TAR и TAR стандарта POSIX.1.
По умолчанию GNU cpio создаёт архивы в двоичном формате, совместимые
со старыми реализациями программы cpio. При извлечении cpio определяет
формат архива автоматически, в частности, правильно восстанавливает
порядок байтов, даже если архив был создан на машине с другой архитектурой.

%description -l uk_UA.KOI8-U
cpio коп╕ю╓ файли в або з арх╕ву cpio або tar, який явля╓ собою файл,
що м╕стить ╕нш╕ файли та ╕нформац╕ю про них, таку як ╕м'я файлу, його
власника, час створення, права доступу ╕ т.╕. Арх╕вом може бути файл,
стр╕чка або пайп.

%description static
This package contains statically linked version of the GNU cpio program.

%description -l ru_RU.UTF-8 static
Статически скомпонованная версия GNU cpio. Занимает больше места,
чем основной, динамически скомпонованный вариант, используемый
по умолчанию, но меньше зависит от общесистемных библиотек
и может пригодиться для аварийных работ.

%prep
%setup
%patch -p1

# Outdated by fresh autoconf.
rm m4/extensions.m4
find -type f -print0 |
	xargs -r0 fgrep -lZ gl_USE_SYSTEM_EXTENSIONS -- |
	xargs -r0 sed -i 's/gl_USE_SYSTEM_EXTENSIONS/AC_USE_SYSTEM_EXTENSIONS/g' --

%build
# Several changes modify configure.ac and Makefile.am
%autoreconf
%configure --disable-mt --with-rmt=/sbin/rmt --disable-silent-rules
%make_build

%check
%make_build -k check

%install
%makeinstall_std
mkdir -p %buildroot/bin
mv %buildroot%_bindir/cpio %buildroot/bin/
mv %buildroot%_bindir/cpio{,.}static

%find_lang %name

%files -f %name.lang
/bin/cpio
%_infodir/cpio.info*
%_mandir/man?/cpio.*
%doc AUTHORS NEWS README THANKS TODO

%files static
%_bindir/cpio.static

%define _unpackaged_files_terminate_build 1

%changelog
