%def_enable python3

Name: cracklib
Version: 2.9.7
Release: alt1

Summary: A password-checking library.
License: %lgpl2plus
Group: System/Libraries
Url: https://github.com/%name/%name

Source: https://github.com/%name/%name/releases/download/v%version/%name-%version.tar.gz

Requires: %name-utils = %version-%release

BuildRequires: rpm-build-licenses python-devel libX11-devel libICE-devel
BuildRequires: zlib-devel
%{?_enable_python3:BuildRequires: rpm-build-python3 python3-devel}

%package utils
Summary: The CrackLib utilities for the build dictionaries.
Group: System/Libraries
Requires: %name = %version-%release

%package devel
Summary: %name link library & header file
Group: Development/C
Requires: %name = %version-%release

%package -n python-module-%name
Summary: Python module of %name
Group: Development/Python
Requires: %name = %version-%release

%package -n python3-module-%name
Summary: Python3 module of %name
Group: Development/Python
Requires: %name = %version-%release

%description
CrackLib tests passwords to determine whether they match certain
security-oriented characteristics. You can use CrackLib to stop
users from choosing passwords which would be easy to guess. CrackLib
performs certain tests:

* It tries to generate words from a username and gecos entry and
  checks those words against the password;
* It checks for simplistic patterns in passwords;
* It checks for the password in a dictionary.

CrackLib is actually a library containing a particular
C function which is used to check the password, as well as
other C functions. CrackLib is not a replacement for a passwd
program; it must be used in conjunction with an existing passwd
program.

Install the %name package if you need a program to check users'
passwords to see if they are at least minimally secure. If you
install CrackLib, you'll also want to install the %name-words
package.

%description devel
The %name devel package include the needed library link and
header files for development.

%description utils
The %name-utils package includes the utilities necessary to
create new dictionaries for Cracklib.

%description -n python-module-%name
This package includes Python module for Cracklib.

%description -n python3-module-%name
This package includes Python3 module for Cracklib.

%prep
%setup -n %name-%version
%setup -D -c -n %name-%version
mv %name-%version py3build

%build
%autoreconf
%configure \
	--disable-static
%make_build

%if_enabled python3
pushd py3build
export PYTHON=python3
export am_cv_python_version=%__python3_version%_python3_abiflags
%autoreconf
%configure \
	--disable-static \
	--with-x
%make_build
popd
%endif

%install
%makeinstall_std

%ifarch x86_64
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_enabled python3
pushd py3build
%makeinstall_std

%ifarch x86_64
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
popd
%endif

# create words database
touch %buildroot%_datadir/%name/pw_dict.{hwm,pwd,pwi}

cat > %name.filetrigger << _EOF_
#!/bin/sh -e

dir=%_datadir/%name
grep -qs '^'\$dir'' && %_sbindir/%name-format \$dir/%{name}* | %_sbindir/%name-packer \$dir/pw_dict >/dev/null ||:
_EOF_

install -pD -m 755 %name.filetrigger %buildroot%_rpmlibdir/%name.filetrigger

%find_lang cracklib

%files -f %name.lang
%_libdir/*.so.*
%_datadir/%name/
%_rpmlibdir/%name.filetrigger
%doc AUTHORS ChangeLog NEWS README*

%files devel
%_includedir/*
%_libdir/*.so

%files utils
%_sbindir/*

%files -n python-module-%name
%python_sitelibdir/*
%exclude %python_sitelibdir/*.la

%if_enabled python3
%files -n python3-module-%name
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.la
%endif

%changelog
