# Use "--disable sql" for build without PostgreSQL and MySQL support
%def_enable sql
# Use "--disable ldap" for build without LDAP support
%def_enable ldap

# p8: TypeError: inline_all_toctrees() takes exactly 5 arguments (6 given)
%def_with sphinx

%define abiversion 3

Name: cyrus-sasl2
Version: 2.1.27
Release: alt2.1

Summary: SASL2 is the Simple Authentication and Security Layer
License: ALT-Cyrus
Group: System/Libraries

URL: http://www.cyrusimap.org/
Packager: Vladimir V Kamarzin <vvk@altlinux.ru>

Source0: %name-%version.tar
Source1: sasldb2
Source2: saslpasswd.conf
Source3: saslauthd.conf
Source4: saslauthd.init
Source5: saslauthd.sysconfig
# It's a converted server-plugin-flow.fig to JPEG
Source7: %name-alt-server-plugin-flow.jpg
Source8: README.ALT

Patch1: bug_3920_rimap.patch

Requires: libsasl2-%abiversion = %version-%release

BuildRequires: libcom_err-devel libdb4-devel libkrb5-devel libpam-devel groff-base autoconf automake openssl-devel
%if_with sphinx
BuildRequires: perl-Pod-POM-View-Restructured
BuildRequires: python-module-sphinx >= 1.6
%endif

%if_enabled sql
BuildRequires: libMySQL-devel postgresql-devel libsqlite3-devel
%endif

%if_enabled ldap
BuildRequires: libldap-devel
%endif

%description
SASL is the Simple Authentication and Security Layer,
a method for adding authentication support to connection-based protocols.
To use SASL, a protocol includes a command for identifying and authenticating
a user to a server and for optionally negotiating protection of subsequent
protocol interactions. If its use is negotiated, a security layer is inserted
between the protocol and the connection.

%package -n libsasl2-%abiversion
Summary: Librairies for SASL a the Simple Authentication and Security Layer
Group: System/Libraries
Requires: shadow-utils
Provides: libsasl2 = %version-%release

%description -n libsasl2-%abiversion
SASL is the Simple Authentication and Security Layer,
a method for adding authentication support to connection-based protocols.
To use SASL, a protocol includes a command for identifying and authenticating
a user to a server and for optionally negotiating protection of subsequent
protocol interactions. If its use is negotiated, a security layer is inserted
between the protocol and the connection.

%package -n libsasl2-devel
Summary: Librairies for SASL a the Simple Authentication and Security Layer
Group: Development/C
Requires: libsasl2-%abiversion = %version-%release

%description -n libsasl2-devel
SASL is the Simple Authentication and Security Layer,
a method for adding authentication support to connection-based protocols.
To use SASL, a protocol includes a command for identifying and authenticating
a user to a server and for optionally negotiating protection of subsequent
protocol interactions. If its use is negotiated, a security layer is inserted
between the protocol and the connection.

%package -n libsasl2-plugin-gssapi
Summary: SASL2 KERBEROS_V5 mechanism plugin
Group: System/Libraries
Requires: libsasl2-%abiversion = %version-%release
Requires: libkrb5 >= 1.3.1-alt3

%description -n libsasl2-plugin-gssapi
This plugin implements the SASL2 KERBEROS_V5 mechanism, allowing
authentication via kerberos version four.
This OPTIONS is EXPERIMENTAL!

%if_enabled ldap
%package -n libsasl2-plugin-ldapdb
Summary: SASL LDAP auxprop+canonuser implementation plugin
Group: System/Libraries
Requires: libsasl2-%abiversion = %version-%release

%description -n libsasl2-plugin-ldapdb
SASL LDAP auxprop+canonuser implementation plugin
%endif


%if_enabled sql
%package -n libsasl2-plugin-sql
Summary: SASL2 MySQL and PostgreSQL mechanism plugin
Group: System/Libraries
Requires: libsasl2-%abiversion = %version-%release
Obsoletes: libsasl2-plugin-mysql
Obsoletes: libsasl2-plugin-pgsql


%description -n libsasl2-plugin-sql
This plugin implements the SASL2 MySQL and PgSQL AUXPROP mechanism.
%endif

%package docs
Summary: SASL2 docs
Group: System/Libraries
BuildArch: noarch

%description docs
This package contains documentations for SASL2

%prep
%setup

#patch1 -p0

%build

%if_enabled sql
export CPPFLAGS="`krb5-config --cflags` -I/usr/include/pgsql $CPPFLAG"
%else
export CPPFLAGS="`krb5-config --cflags` $CPPFLAG"
%endif

libtoolize -c -f
aclocal -I cmulocal -I config
autoheader
autoconf
automake -a -c -f

#pushd saslauthd
#aclocal -I ../cmulocal -I config -I ../config
#autoheader
#autoconf
#automake -a -c -f
#popd

%add_optflags %optflags_shared
#version_script="$(readlink -ev libsasl2.map)"
#add_optflags -Wl,--version-script=$version_script

%configure	--enable-shared \
		--with-configdir=%_sysconfdir/sasl2 \
		--libdir=/%_lib \
		--with-plugindir=%_libdir/sasl2-%abiversion \
		--with-dbpath=%_sysconfdir/sasl2/sasldb2 \
		--with-dblib=berkeley \
		--with-devrandom=/dev/urandom \
		--with-openssl \
		--with-des \
		--with-pam \
		--with-saslauthd=%_var/run/saslauthd \
		--with-rc4 \
%if_enabled ldap
		--with-ldap=%_prefix \
		--enable-ldapdb \
%endif
%if_enabled sql
		--with-mysql=%_prefix \
		--with-pgsql=%_prefix \
		--with-sqlite3==%_prefix \
		--enable-sql \
%endif
		--enable-anon \
		--enable-cram \
		--enable-plain \
		--enable-login \
		--enable-gssapi \
		--enable-ntlm \
		--enable-digest \
		--enable-srp \
		--enable-otp \
		%{?_without_sphinx: --with-sphinx-build=no} \
		#

sed -i 's,/usr/local/lib,%_libdir,g' saslauthd/Makefile

# fixed libraries path in RPATH
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool

%make_build

pushd saslauthd
make testsaslauthd
popd

%install

%set_verify_elf_method unresolved=relaxed

mkdir -p %buildroot{%_bindir,%_libdir}
make install DESTDIR=%buildroot

#install -m 755 saslauthd/testsaslauthd %buildroot%_bindir

pushd %buildroot/%_libdir
    ln -s -nf ../../%_lib/libsasl2.so.3 libsasl2.so
popd

mkdir -p %buildroot%_sysconfdir
mkdir -p %buildroot%_mandir/man8

# some files are currently not installed by the Makefile
cp utils/sasldblistusers2.8 %buildroot%_mandir/man8/
cp utils/saslpasswd2.8 %buildroot%_mandir/man8/
cp saslauthd/saslauthd.mdoc %buildroot%_mandir/man8/saslauthd.8
#mv %buildroot%_mandir/cat8/saslauthd.8 %buildroot%_mandir/man8
cp utils/.libs/dbconverter-2 %buildroot%_sbindir
rm -fr %buildroot%_mandir/cat8

mkdir -p %buildroot%_docdir/%name-%version
mkdir -p %buildroot%_docdir/%name-%version/saslauthd
install -p -m 0644 saslauthd/{README.ipc,README.cache,LDAP_SASLAUTHD,COPYING,ChangeLog} %buildroot%_docdir/%name-%version/saslauthd

install -p -m 0644 {%SOURCE8,COPYING,AUTHORS,INSTALL.TXT,README.*,ChangeLog,doc/legacy/TODO} %buildroot%_docdir/%name-%version

mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%_var/run/saslauthd
mkdir -p %buildroot%_sysconfdir/sasl2

install -m0600 %SOURCE1 %buildroot%_sysconfdir/sasl2
install -m0600 %SOURCE2 %buildroot%_sysconfdir/sasl2
install -m0600 %SOURCE3 %buildroot%_sysconfdir/sasl2

install -m0755 %SOURCE4 %buildroot%_initdir/saslauthd
install -m0600 %SOURCE5 %buildroot%_sysconfdir/sysconfig/saslauthd

mkdir -p %buildroot%_pkgconfigdir
mv -f  %buildroot/%_lib/pkgconfig/libsasl2.pc %buildroot%_pkgconfigdir/libsasl2.pc
rm -fr %buildroot/%_lib/pkgconfig

rm -f %buildroot%_libdir/sasl2-%abiversion/*.la

# show it in build's log
ls -l %buildroot/%_lib/*
ls -l %buildroot%_man3dir/*

%post
%post_service saslauthd
%preun
%preun_service saslauthd

%pre -n libsasl2-%abiversion
%_sbindir/groupadd -rf sasl ||:

%files
%config(noreplace) %attr(0640,root,root) %_sysconfdir/sasl2/saslpasswd.conf
%config(noreplace) %attr(0640,root,root) %_sysconfdir/sasl2/saslauthd.conf
%config(noreplace) %attr(0600,root,root) %_sysconfdir/sysconfig/saslauthd
%attr(0755,root,root) %_initdir/saslauthd
#_bindir/*
%_sbindir/*
%_man8dir/*
%attr(0711,root,root) %dir %_var/run/saslauthd

%files -n libsasl2-%abiversion
%config(noreplace) %attr(0640,root,sasl) %_sysconfdir/sasl2/sasldb2
%dir %_sysconfdir/sasl2
%dir %_libdir/sasl2-%abiversion
/%_lib/*.so.*
%_libdir/sasl2-%abiversion/libanonymous.so*
%_libdir/sasl2-%abiversion/libcrammd5.so*
%_libdir/sasl2-%abiversion/libdigestmd5.so*
%_libdir/sasl2-%abiversion/liblogin.so*
%_libdir/sasl2-%abiversion/libntlm.so*
%_libdir/sasl2-%abiversion/libotp.so*
%_libdir/sasl2-%abiversion/libplain.so*
%_libdir/sasl2-%abiversion/libsasldb.so*
%_libdir/sasl2-%abiversion/libsrp.so*
%_libdir/sasl2-%abiversion/libscram.so*
%_libdir/sasl2-%abiversion/libgs2.so*

%doc COPYING AUTHORS INSTALL.TXT README.* ChangeLog doc/legacy/TODO

%files -n libsasl2-devel
%dir %_includedir/sasl
%_includedir/sasl/*
%if_with sphinx
%_mandir/man3/*
%endif
%_libdir/*.so
/%_lib/*.so
%_pkgconfigdir/*

%files docs
%doc %_docdir/%name-%version

%files -n libsasl2-plugin-gssapi
%_libdir/sasl2-%abiversion/libgssapiv2.so*

%if_enabled ldap
%files -n libsasl2-plugin-ldapdb
%_libdir/sasl2-%abiversion/libldapdb.so*
%endif

%if_enabled sql
%files -n libsasl2-plugin-sql
%_libdir/sasl2-%abiversion/libsql.so*
%endif

%changelog
