%def_disable snapshot

%define _unpackaged_files_terminate_build 1
%define ver_major 3.32
%define xdg_name ca.desrt.dconf-editor

Name: dconf-editor
Version: %ver_major.0
Release: alt1

Summary: dconf confuguration editor
Group: Graphical desktop/GNOME
License: GPLv3
Url: https://wiki.gnome.org/Projects/dconf

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.55.1
%define gtk_ver 3.22.27
%define dconf_ver 0.26.1
%define vala_ver 0.36.11

Requires: dconf >= %dconf_ver

BuildRequires(pre): meson
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver libdconf-devel >= %dconf_ver
BuildPreReq: vala-tools >= %vala_ver
BuildRequires: libxml2-devel rpm-build-gnome
BuildRequires: libappstream-glib-devel yelp-tools
BuildRequires: libdconf-vala

%description
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package provides graphical dconf configuration editor.


%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name dconf

%files -f %name.lang
%_bindir/%name
%_datadir/applications/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/*/*.*
%_man1dir/%name.1.*
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
# "nosort" bad option?
%_datadir/bash-completion/completions/%name
%doc README

%changelog
