%define diethome %_prefix/lib/%name

Name: dietlibc
%define cvsdate %nil
Version: 0.33
Release: alt3
Summary: C library optimized for size
License: GPLv2+
Group: Development/C
Url: http://www.fefe.de/%name/
%if 0%{?cvsdate:%cvsdate}
Source: %name-cvs-%cvsdate.tar
%else
Source: ftp://ftp.kernel.org/pub/linux/libs/%name/%name-%version.tar
%endif
Source1: %name-Makefile.rules
Patch: %name-%version-%release.patch

%description
Small libc for building embedded applications.


%prep
%if 0%{?cvsdate:%cvsdate}
%setup -q -n %name-cvs-%cvsdate
%else
%setup -q
%endif
%patch -p1


%build
%define _optlevel s
%add_optflags -fno-stack-protector -U_FORTIFY_SOURCE -fno-asynchronous-unwind-tables

DisableFeatures()
{
local F
for F in $@; do
	sed -i -r -e '/^#[[:blank:]]*define[[:blank:]]+WANT_'"$F"'[[:blank:]]*$/s|^.*$|/* & */|' dietfeatures.h
done
}

EnableFeatures()
{
local F
for F in $@; do
	sed -i -r -e '/^\/\*[[:blank:]]*#[[:blank:]]*define[[:blank:]]+WANT_'"$F"'[[:blank:]]*\*\/$/s|^.*(#.*)[[:blank:]]*\*\/|\1|' \
	          -e 's/[[:blank:]]*$//' dietfeatures.h
done
}

DisableFeatures \
	FASTER_STRING_ROUTINES \
	LLMNR \
	VALGRIND_SUPPORT \
	FREAD_OPTIMIZATION \
	LD_SO_GDB_SUPPORT \
	IPV6_DNS \
	HIGH_PRECISION_MATH \
	SSP \
	STACKGAP
EnableFeatures \
	MALLOC_ZERO

%make_build CC="%__cc" CFLAGS="%optflags" prefix=%diethome
gzip -9c CHANGES > CHANGES.gz


%install
%make_install prefix=%diethome BINDIR=%_bindir MAN1DIR=%_man1dir DESTDIR=%buildroot install
install -p -m 0644 %SOURCE1 %buildroot%diethome/Makefile.rules


%files
%doc AUTHOR BUGS CAVEAT CHANGES.* FAQ PORTING README* THANKS SECURITY TODO
%_bindir/*
%_man1dir/*
%diethome


%changelog
