Name: diffutils
Version: 3.7
Release: alt1
%define srcname %name-%version-%release

Summary: A GNU collection of diff utilities
License: GPLv3+
Group: File tools
Url: https://www.gnu.org/software/diffutils/

# git://git.sv.gnu.org/diffutils refs/heads/master
# git://git.altlinux.org/people/ldv/packages/diffutils refs/heads/diffutils-current
Source0: %srcname.tar
# translationproject.org::tp/latest/diffutils/
# git://git.altlinux.org/people/ldv/packages/diffutils refs/heads/po-current
Source1: po-%version-%release.tar

Conflicts: man-pages <= 1.52-alt1

BuildRequires: gnulib >= 0.1.2305.95c96
BuildRequires: gperf help2man makeinfo

%description
Diffutils includes four utilities: diff, cmp, diff3 and sdiff:
+ The diff command compares two files and shows the differences,
  line by line.
+ The cmp command compares two files, and if they differ, tells the
  first byte and line number where they differ or reports that one file
  is a prefix of the other.
+ The diff3 command compares three files and outputs descriptions of
  their differences.
+ The sdiff command merges two files and interactively outputs the
  results.

%prep
%setup -n %srcname -a1

# Build scripts expect to find the diffutils version in this file.
echo -n %version > .tarball-version

# git and rsync aren't needed for build.
sed -i '/^\(git\|rsync\)[[:space:]]/d' bootstrap.conf

# Generate LINGUAS file.
ls po/*.po | sed 's|.*/||; s|\.po$||' > po/LINGUAS

%build
./bootstrap --skip-po --gnulib-srcdir=%_datadir/gnulib
# Predefine location of the pr utility.
export PR_PROGRAM=%_bindir/pr
%configure --disable-silent-rules
%make_build

%install
%makeinstall_std
%find_lang %name

%check
%make_build -k check

%files -f %name.lang
%_bindir/*
%_infodir/*.info*
%_mandir/man?/*
%doc AUTHORS NEWS README THANKS

%changelog
