# git describe upstream/dolphin-emu | sed 's/-g[0-9a-f]*\(+*\)$/\1/'
%define git_version 5.0-15445
# git show-ref --heads --hash upstream/dolphin-emu
%define git_commit db02b50d2ecdfbbc21e19aadc57253c353069f77

%define mgba_commit 9cccc5197ed73ba0a54f584d3121c27dc97405f5

%add_optflags %optflags_shared

Name: dolphin-emu
Version: 5.0.15445
Release: alt0.p9.1

Summary: The Gamecube / Wii Emulator
License: GPLv2
Group: Emulators

Url: https://%name.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64 aarch64

# https://github.com/%name/dolphin/archive/%git_commit/dolphin-%git_commit.tar.gz
Source0: dolphin-%git_commit.tar
# https://github.com/mgba-emu/mgba/archive/%mgba_commit/mgba-%mgba_commit.tar.gz
Source1: mgba-%mgba_commit.tar

Patch0: %name-alt-git.patch

BuildPreReq: pkgconfig(expat)
BuildPreReq: pkgconfig(libbrotlicommon)
BuildPreReq: pkgconfig(libpcre)
BuildPreReq: pkgconfig(uuid)

BuildRequires: cmake
BuildRequires: libcubeb-devel
BuildRequires: libmbedtls-devel
BuildRequires: libminiupnpc-devel
BuildRequires: llvm12.0-devel-static
BuildRequires: pkgconfig(Qt5)
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(bluez)
BuildRequires: pkgconfig(fmt) >= 7.1
BuildRequires: pkgconfig(hidapi-libusb)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libenet)
BuildRequires: pkgconfig(libevdev)
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libswresample)
BuildRequires: pkgconfig(libswscale)
BuildRequires: pkgconfig(libusb-1.0)
BuildRequires: pkgconfig(libzstd)
BuildRequires: pkgconfig(lzo2)
BuildRequires: pkgconfig(minizip-ng)
BuildRequires: pkgconfig(pugixml)
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(sfml-all)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xdmcp)
BuildRequires: pkgconfig(xft)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xinerama)
BuildRequires: pkgconfig(xmu)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xxf86vm)
BuildRequires: pkgconfig(udev)

%description
Dolphin-emu is a emulator for Gamecube, Wii, Triforce that lets
you run Wii/GCN/Tri games on your Windows/Linux/Mac PC system.

%prep
%setup -n dolphin-%git_commit -b 1
%patch0 -p1

%__mv -Tf ../mgba-%mgba_commit Externals/mGBA/mgba

%build
%cmake .. \
	-DENABLE_LTO:BOOL=TRUE \
	-DUSE_SHARED_ENET:BOOL=TRUE \
	-DDOLPHIN_WC_DESCRIBE:STRING="%git_version" \
	-DDOLPHIN_WC_REVISION:STRING="%git_commit" \
	-DDOLPHIN_WC_BRANCH:STRING="master" \
	-DDISTRIBUTOR:STRING="ALT Linux Team" \
	-Wno-dev

%cmake_build

%install
%cmake_install
%__install -Dp -m0644 Data/51-usb-device.rules %buildroot%_udevrulesdir/51-%name-usb-device.rules
%find_lang %name

%files -f %name.lang
%_bindir/*
%_desktopdir/%name.desktop
%_datadir/%name
%_iconsdir/hicolor/256x256/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_man6dir/%{name}*
%config %_udevrulesdir/51-%name-usb-device.rules

%changelog
