%def_with gtk

Name: doublecmd
Summary: Twin-panel (commander-style) file manager
Version: 0.9.10
Release: alt1
Epoch:   1
Url: https://doublecmd.sourceforge.io

Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: %name-%version.tar
Source1: %name-qt.desktop
License: GPLv2+ and LGPLv2+ and Expat and MPL-1.1 and MPL-2.0 and Apache-2.0 and BSD and Expat and Zlib
Group: File tools

BuildRequires: fpc >= 2.6.2
BuildRequires: fpc-src
%if_with gtk
# lcl_gtk3 is still unstable in Lazarus
BuildRequires: libgtk+2-devel
%endif
BuildRequires: lazarus >= 1.0.10
BuildRequires: qt5pas-devel
BuildRequires: ImageMagick-tools
BuildRequires: libdbus-devel
BuildRequires: bzlib-devel
BuildRequires: /proc

Patch0: doublecmd-use-default-terminal.patch
Patch1: doublecmd-not-install-zdli.patch
Patch2: doublecmd-alt-build-in-one-thread.patch

ExclusiveArch: x86_64 aarch64

%description
Double Commander is a cross platform open source file manager with two panels
side by side. It is inspired by Total Commander and features some new ideas.

%if_with gtk
%package -n %name-gtk
Summary: Twin-panel (commander-style) file manager (GTK)
Group: File tools
Requires: %name-common
Provides: %name
Obsoletes: %name < 0.6.1

%description -n %name-gtk
Double Commander GTK is a cross platform open source file manager with
two panels side by side.  It is inspired by Total Commander and features
some new ideas.
%endif

%package -n %name-qt
Summary: Twin-panel (commander-style) file manager (Qt5)
Group: File tools
Requires: %name-common

%description -n %name-qt
Double Commander Qt5 is a cross platform open source file manager with
two panels side by side.  It is inspired by Total Commander and features
some new ideas.

%package -n %name-common
Summary: Common files for Double Commander
Group: File tools

%description -n %name-common
Common files for Double Commander

%prep
%setup
%patch0 -p2
%patch1 -p2
%patch2 -p2

%build
export MAKEOPTS="-XX"
lcl=qt5 ./build.sh beta
cp ./%name ./%name-qt
%if_with gtk
./clean.sh
lcl=gtk2 ./build.sh beta
%endif

%ifarch %ix86
# To fix ... "oblom" ... when processing install ;)
%set_verify_elf_method textrel=relaxed
%endif

%install
%ifarch aarch64
export CPU_TARGET=x86_64
%endif
install/linux/install.sh --install-prefix=%buildroot
install -d %buildroot%_bindir
install -Dpm0755 ./%name-qt %buildroot%_libdir/%name/%name-qt
ln -s ../%_lib/%name/%name-qt %buildroot%_bindir/%name-qt
# Adapt polkit rule for doublecmd-qt
cp %buildroot%_datadir/polkit-1/actions/org.doublecmd{,-qt}.root.policy
subst 's|%_bindir/%name|%_bindir/%name-qt|' %buildroot%_datadir/polkit-1/actions/org.doublecmd-qt.root.policy
%if_without gtk
rm -f %buildroot%_libdir/%name/%name \
      %buildroot%_bindir/%name \
      %buildroot%_desktopdir/%name.desktop \
      %buildroot%_datadir/polkit-1/actions/org.doublecmd.root.policy
%endif
install -Dpm0644 %SOURCE1 %buildroot%_desktopdir/%name-qt.desktop

# icons
%__mkdir -p %buildroot/{%_miconsdir,%_niconsdir,%_liconsdir}
convert -resize 48x48 pixmaps/mainicon/alt/256px-dcfinal.png %buildroot%_liconsdir/%name.png
convert -resize 32x32 pixmaps/mainicon/alt/256px-dcfinal.png %buildroot%_niconsdir/%name.png
convert -resize 16x16 pixmaps/mainicon/alt/256px-dcfinal.png %buildroot%_miconsdir/%name.png

%if_with gtk
%files -n %name-gtk
%_bindir/%name
%_libdir/%name/%name
%_desktopdir/%name.desktop
%_datadir/polkit-1/actions/org.doublecmd.root.policy
%endif

%files -n %name-qt
%_bindir/%name-qt
%_libdir/%name/%name-qt
%_desktopdir/%name-qt.desktop
%_datadir/polkit-1/actions/org.doublecmd-qt.root.policy

%files -n %name-common
%doc doc/README.txt
%exclude %_libdir/%name/%name-qt
%exclude %_bindir/%name-qt
%if_with gtk
%exclude %_libdir/%name/%name
%exclude %_bindir/%name
%endif
%_libdir/%name
%_datadir/%name
%_man1dir/%name.*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_pixmapsdir/%name.png

%changelog
