## define _requires_exceptions perl(controllib.pl)\\|perl(file)
%def_without extbuild

Name: dpkg
Version: 1.19.5
Release: alt1

Summary: Package maintenance system for Debian Linux

License: GPLv2+
Group: System/Configuration/Packaging
Url: http://packages.debian.org/unstable/base/dpkg

Source0: http://ftp.debian.org/debian/pool/main/d/dpkg/%{name}_%version.tar.xz
Patch: dpkg-ALT-e2k-cputable.patch

# Automatically added by buildreq on Tue Feb 20 2018
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 perl perl-Locale-gettext perl-parent perl-podlators pkg-config python-base xz
BuildRequires: perl-podlators zlib-devel

# boostrap notes:
# 1) build dep loop via perl-Dpkg (just add noarch package);
# 2) dpkg stub is really needed (for abitable, cputable, ostable,
#    triplettable and --print-architecture); DIY or ask mike@

%{?!_with_bootstrap:BuildRequires: po4a}

BuildRequires: perl-Storable perl-TimeDate perl-File-FcntlLock perl-parent perl-Time-Piece

%description
This is dpkg, Debian's package maintenance system.

%package -n perl-Dpkg
Summary: Package maintenance system for Debian Linux
Group: Development/Perl
BuildArch: noarch

%description -n perl-Dpkg
This module provides dpkg functionalities.

%set_perl_req_method relaxed
%prep
%setup
%patch -p2

%build
%autoreconf
%configure \
    --disable-update-alternatives \
    --disable-start-stop-daemon \
    --disable-dselect \
    --with-admindir=/var/lib/%name \
    --with-logdir=/var/lib/%name/log

%make

%install
%makeinstall_std

rm -f %buildroot%_man7dir/deb-version.*

# cleanup
%if_without extbuild
rm -rf %buildroot%_mandir/??/
rm -rf %buildroot%_includedir/dpkg/*
rm -rf %buildroot%_libdir/libdpkg.a
rm -rf %buildroot%_libdir/pkgconfig/libdpkg.pc
%endif

%find_lang %name
%find_lang dpkg-dev
cat dpkg-dev.lang >> %name.lang

%files -f dpkg.lang
%attr(0755,root,root) %_bindir/dpkg*
%dir %_datadir/%name
%_datadir/%name/*table
%_datadir/%name/*.mk
%_datadir/%name/*.specs
%dir /var/lib/%name/
/var/lib/%name/*
%dir %_sysconfdir/%name
%_man1dir/dpkg*
%_man5dir/*
%if_with extbuild
%lang(pl) %_mandir/pl/man?/*
%lang(de) %_mandir/de/man?/*
%lang(ja) %_mandir/ja/man?/*
%lang(sv) %_mandir/sv/man?/*
%lang(fr) %_mandir/fr/man?/*
%lang(hu) %_mandir/hu/man?/*
%lang(es) %_mandir/es/man?/*
%lang(it) %_mandir/it/man?/*
%_includedir/dpkg/*
%_libdir/libdpkg.a
%_libdir/pkgconfig/libdpkg.pc
%endif

%files -n perl-Dpkg
%_man3dir/*
%perl_vendorlib/Dpkg/
%perl_vendorlib/Dpkg.pm

%changelog
