# $Id: duma.spec 6105 2008-01-21 09:55:51Z dries $
# Authority: dries
# Upstream:  Hayati Ayguen <h_ayguen$web,de>

%define real_version 2_5_15

Summary: Detect Unintended Memory Access
Name: duma
Version: 2.5.15
Release: alt3
License: GPL
Group: Development/Other
Url: http://duma.sourceforge.net/

Source: http://dl.sf.net/duma/duma_%real_version.tar.gz
Patch: duma-LEAKDETECTION.patch

BuildRequires: gcc-c++

%description
DUMA (Detect Unintended Memory Access) stops your program on the exact
instruction that overruns (or underruns) a malloc() memory buffer. GDB
will then display the source-code line that causes the bug. It works by
using the virtual-memory hardware to create a red-zone at the border of
each buffer: touch that, and your program stops. It can catch formerly
impossible-to-catch overrun bugs.

DUMA is a fork of Bruce Perens' Electric Fence library.

%package devel
Summary: Header files, libraries and development documentation for %name
Group: Development/Other
Requires: %name = %version-%release

%description devel
This package contains the header files, static libraries and development
documentation for %name. If you like to develop programs using %name,
you will need to install %name-devel.

%prep
%setup -n duma_%real_version
%patch -p0
find . -depth -name CVS -exec rm -rf {} \;
sed -i 's@[.]/libduma@%_libdir/libduma@g' duma.sh
sed -i 's@%_lib/@%_libdir@g' gdbinit.rc

%build
# duma doesn't build with _smp_mflags
%make all OS=linux CXX="g++ -std=c++98"

%install
%makeinstall

%check
%make test

%files
%doc INSTALL README.txt TODO gdbinit.rc
%_man3dir/duma.3*
%_bindir/duma
%_libdir/libduma.so.*

%files devel
%doc comparisons example*
%_libdir/libduma.a
%_libdir/libduma.so
%_includedir/*

%changelog
