Name: dwm
Version: 6.1
Release: alt1

Summary: Dynamic window manager for X

License: MIT
Group: Graphical desktop/Other
Url: http://dwm.suckless.org/

# Repacked http://www.suckless.org/download/%name-%version.tar.gz
Source: %name-%version.tar
Source1: dwm.wmsession
Source2: dwm-start
Source3: dwm-start.1

Patch0: dwm-user-notes.patch

# Automatically added by buildreq on Fri Sep 16 2016
# optimized out: fontconfig fontconfig-devel libX11-devel libXrender-devel libfreetype-devel python-base xorg-renderproto-devel xorg-xproto-devel
BuildRequires: libXft-devel libXinerama-devel

Requires: st

%description
dwm is a dynamic window manager for X.
It manages windows in tiling and floating modes.  Either mode can be
applied dynamically, optimizing the environment for the application in
use and the task performed. It is the little brother of wmii.

%prep
%setup
%patch -p1
# Nuke the silent build.
sed -i.backup -e 's|\t@|\t|' Makefile
cmp -s Makefile{,.backup} && false
# Insert optflags
sed -i.backup -e 's|-Os|%optflags -D_DEFAULT_SOURCE|' config.mk
cmp -s config.mk{,.backup} && false
# No strip for debuginfo, and insert ldflags to enhance the security.
sed -i.backup -e 's|-s ${LIBS}|${LIBS}|' config.mk
cmp -s config.mk{,.backup} && false
# X includedir path fix
sed -i.backup -e 's|X11INC = .*|X11INC = %_includedir|' config.mk
cmp -s config.mk{,.backup} && false
# libdir path fix
sed -i.backup -e 's|X11LIB = .*|X11LIB = %_libdir|' config.mk
cmp -s config.mk{,.backup} && false

%build
%make_build

%install
%makeinstall_std PREFIX=%prefix

install -pD -m 644 %SOURCE1 %buildroot%_sysconfdir/X11/wmsession.d/14%name

install -m755 %SOURCE2 %buildroot%_bindir/dwm-start
install -m644 %SOURCE3 %buildroot%_man1dir/dwm-start.1
sed -i "s/VERSION/%version/;s/RELEASE/%release/" \
	%buildroot%_man1dir/dwm-start.1

%files
%_bindir/dwm
%_bindir/dwm-start
%_man1dir/dwm.1*
%_man1dir/dwm-start.1*
%doc README
%config %_sysconfdir/X11/wmsession.d/14%name

%changelog
