Name: eeepc-acpi-scripts
Version: 1.1.9
Release: alt5

Summary: Debian eeePC support scripts
License: GPL
Group: System/Kernel and hardware

BuildArch: noarch

Url: http://git.debian.org/?p=debian-eeepc/eeepc-acpi-scripts.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: acpid udev amixer aosd_cat
Requires: rfkill >= 0.3.3

Conflicts: eeepc-scripts


%description
This package adds support to the special features of Asus Eee PC series of
laptops. These include sleep (suspend) and hotkeys such as wireless,
brightness, mute, volume, video output toggle and the 'soft' keys available in
some models.


%prep
%setup
%patch -p1
#sed -i 's,/etc/default,%_datadir,g' etc/acpi/*/*

%install
mkdir -p %buildroot%_sysconfdir/acpi/{actions,events,lib}
install -p -m0755 etc/acpi/actions/* %buildroot%_sysconfdir/acpi/actions/
install -p -m0644 etc/acpi/events/* %buildroot%_sysconfdir/acpi/events/
install -p -m0644 etc/acpi/lib/* %buildroot%_sysconfdir/acpi/lib/

mkdir -p %buildroot%_sysconfdir/modprobe.d
install -p -m0644 etc/modprobe.d/* %buildroot%_sysconfdir/modprobe.d/

mkdir -p %buildroot/lib/udev/rules.d
install -p -m0644 lib/udev/rules.d/* %buildroot/lib/udev/rules.d/
install -p -m0755 lib/udev/[^r]* %buildroot/lib/udev/

mkdir -p %buildroot%_datadir/%name
install -p -m0644 functions.sh %buildroot%_datadir/%name/

install -pD -m0644 debian/eeepc-acpi-scripts.default.in %buildroot%_sysconfdir/default/%name
install -pD -m0755 debian/eeepc-acpi-scripts.init %buildroot%_initdir/%name

mkdir -p %buildroot%_sysconfdir/sysconfig/%name.d
cat > %buildroot%_sysconfdir/sysconfig/%name.d/00README << _E_O_F_
# put here custom configuration snippets
# do not remove or edit THIS file
_E_O_F_

mkdir -p %buildroot%_localstatedir/%name

%post
%post_service %name
%_initdir/acpid condreload

%preun
%preun_service %name
%_initdir/acpid condreload


%files
%_sysconfdir/acpi/*
%_sysconfdir/modprobe.d/*
%_sysconfdir/default/%name
%_sysconfdir/sysconfig/%name.d
%_initdir/%name
/lib/udev/*
%exclude %dir /lib/udev/rules.d/
%_datadir/%name/
%_localstatedir/%name/
%doc TODO debian/NEWS debian/README.Debian debian/changelog debian/copyright


%changelog
