# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: emacs-bbdb.spec,v 1.1 2005/10/01 19:30:09 eugene Exp $

%define cvsdate 20050811
%define pkg_name bbdb
%define rel_base 3

Version: 2.35
%ifdef cvsbuild
Release: alt%rel_base.%cvsdate
%else
Release: alt%rel_base
%endif
Name: emacs-%pkg_name
License: GPL
Group: Editors
Url: http://%pkg_name.sourceforge.net/
Summary: BBDB package for Emacs
Summary(ru_RU.UTF-8): Big Brother Database для Emacs
Requires: emacs-common gnus

Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>

%ifdef cvsbuild
Source: %pkg_name-%cvsdate.tar.gz
%else
Source: %pkg_name-%version.tar.gz
%endif
Source1: %pkg_name-emacs.el

BuildArch: noarch

# Automatically added by buildreq on Thu Jul 26 2002
BuildRequires: emacs-common texinfo gnus emacs-leim
BuildPreReq: autoconf >= 2.53, automake >= 1.7

%description
Big Brother Database for Emacs

All Emacs Lisp code is byte-copmpiled, install %name-el for sources.

%description -l ru_RU.UTF-8
Big Brother Database для Emacs

Весь код на Emacs Lisp откомпилирован, для получения исходных текстов установите
пакет %name-el

%package el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other
Requires: %name = %version-%release

%description el
%name-el contains the Emacs Lisp sources for the bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

%description el -l ru_RU.UTF-8
Пакет %name-el содержит исходные тексты для пакета %name, который
является дополнением к редактору Emacs.

%name-el необходим вам только, если вы собираетесь изменять файлы
входящие в %name, или хотите посмотреть некоторые примеры.

%prep
%ifdef cvsbuild
%setup -q -n %pkg_name
%else
%setup -q -n %pkg_name-%version
%endif

%build
autoconf
%configure --with-lispdir=%_emacslispdir/%pkg_name \
           --enable-gnus --enable-rmail
make

%install
%__mkdir_p %buildroot%_emacslispdir/%pkg_name
%__install -m 644 lisp/*.el* %buildroot%_emacslispdir/%pkg_name

%__mkdir_p %buildroot%_infodir
%__install -m 644 texinfo/*.info* %buildroot%_infodir/

%__mkdir_p %buildroot/etc/emacs/site-start.d
%__install -m 644 %SOURCE1 %buildroot/etc/emacs/site-start.d/%pkg_name.el

%files
%doc ChangeLog README INSTALL
%_infodir/*
%dir %_emacslispdir/%pkg_name
%_emacslispdir/%pkg_name/*.elc
%config(noreplace) /etc/emacs/site-start.d/*

%files el
%_emacslispdir/%pkg_name/*.el

%changelog
