%def_without texmf
%define emacsbin emacs
# define emacsbin emacs-nox
%define ModeName auctex
%define emacs_version %(%emacsbin --version | head --lines=1 | cut -d' ' --fields=3 | cut -d. --fields=1,2)
%if "%emacs_version" == ""
# Not to leave the macro undefined in case of no emacs.
%define emacs_version 0
%endif
%define _aucstatedir %_localstatedir/%ModeName

Name: emacs-mode-%ModeName
Version: 11.87
Release: alt3

Summary: Enhanced LaTeX mode for GNU Emacs
License: GPL
Group: Editors
Url: http://www.gnu.org/software/auctex/index.html
Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>
BuildArch: noarch

#Source0: ftp://sunsite.auc.dk/packages/auctex/%ModeName-%version.tar.bz2
Source0: ftp://ftp.gnu.org/pub/gnu/auctex/%ModeName-%version.tar.gz
Source1: auctex.el

Source10: %name-11.10-info.ALT

Patch1: %ModeName-11.87-printerlist.patch
Patch2: %ModeName-9.9p-customize.patch
Patch3: %ModeName-rumakeindex.patch

# Due to patches 1 and 2, the administrator of a system won't have to set
# any site-specific variables for AUC TeX.

Requires: common-licenses
Requires: emacs >= %emacs_version
%if_with texmf
Requires: texmf-latex-preview
%else
Requires: tex(preview.sty)
%endif

Provides: preview-latex
Provides: emacs-preview-latex = %version-%release
Obsoletes: emacs-preview-latex < 11.82
Obsoletes: auctex

Requires: gnu-ghostscript /usr/bin/dvips /usr/bin/latex

%define require_compiler %(rpm -qf "$(which %emacsbin)" --queryformat=%%{NAME} 2> /dev/null)

# Automatically added by buildreq on Fri Feb 22 2019
# optimized out: emacs-base emacs-common fontconfig ghostscript-classic libX11-locales libp11-kit libsasl2-3 perl python-base python-modules sh4 tex-common texlive texlive-collection-basic
BuildRequires: emacs-nox texlive-dist

BuildRequires(pre): rpm-build-tex
BuildRequires: fontconfig /usr/bin/dvips /usr/bin/latex

%if "%require_compiler" != ""
BuildPreReq: %require_compiler
%(echo '%require_compiler provides the used Emacs Lisp compiler (%emacsbin)' 1>&2)
%else
BuildPreReq: emacs
%(echo 'emacs provides the used Emacs Lisp compiler (%emacsbin)' 1>&2)
%endif

%description
AUC TeX is a comprehensive, customizable, integrated environment for
writing, editing and processing input files for LaTeX using GNU Emacs.
This mode also supports graphic preview for formulas and figures.

(Emacs Lisp code is principally byte-compiled, install %name-el for sources.)

%package el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other

Requires: %name = %version-%release
Provides: emacs-preview-latex-el = %version-%release

%description el
%name-el contains the Emacs Lisp sources for the bytecode included in the %name package,
that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

#FIXME: fix install to texlive
%package doc
Summary: 	Documentation for %name
Group: 		Editors

Requires: emacs-mode-auctex 
Requires: /usr/share/texmf/doc

%description -n emacs-mode-auctex-doc
Does your neck hurt from turning between previewer windows and the
source too often? This Elisp/LaTeX package will render your displayed
LaTeX equations right into the editing window where they belong. 

This package contains the documentation.

%package -n texmf-latex-preview
Summary: Preview style for TeX subsystems.
Group: Development/Other
BuildArch: noarch

%description -n texmf-latex-preview
%name-el contains the Emacs Lisp sources for the bytecode included in the %name package,
that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

%prep
%setup -q -n %ModeName-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%configure --with-emacs=%emacsbin --with-tex-input-dirs=/usr/share/texmf/tex 
%make_build 

%install
install -d $RPM_BUILD_ROOT{%_emacslispdir/site-start.d,%_infodir}

%define _makeinstall_target install
%makeinstall %_makeinstall_target
install -d %buildroot/etc/emacs/site-start.d
install -m 644 %SOURCE1 %buildroot/etc/emacs/site-start.d/auctex.el

# install ALT's info:
install -m0644 %SOURCE10 ALT-packaging-info

# The license:
ln -s -f %_licensedir/GPL-2 COPYING

rm -f $RPM_BUILD_ROOT/%_infodir/dir
mkdir -p $RPM_BUILD_ROOT/%_docdir/%name-%version/
mv -f $RPM_BUILD_ROOT/%_docdir/auctex/* $RPM_BUILD_ROOT/%_docdir/%name-%version/


%files
%doc --no-dereference COPYING
%_infodir/*
%config(noreplace) %_sysconfdir/emacs/site-start.d/auctex.el
%_aucstatedir
%_emacslispdir/tex-site.el 
%exclude %_emacslispdir/site-start.d/auctex.el
%exclude %_emacslispdir/site-start.d/preview-latex.el
%_emacslispdir/auctex
%_datadir/texmf/tex/latex/preview
%exclude %_texmfmain/tex/latex/preview/preview.sty
%exclude %_emacslispdir/auctex/*.el
%exclude %_emacslispdir/auctex/style/*.el

%files el 
%_emacslispdir/auctex/*.el
%_emacslispdir/auctex/style/*.el

%files -n %name-doc
%_datadir/texmf/doc/latex/styles/*
%doc ChangeLog
%doc ALT-packaging-info

%if_with texmf
%files -n texmf-latex-preview
%_texmfmain/tex/latex/preview/preview.sty
%endif

%changelog
