%define _libexecdir %_prefix/libexec
%define oldname eog2
%define ver_major 3.32
%define xdg_name org.gnome.eog
%define api_ver 3.0
%def_enable color_management
%def_enable introspection
%def_enable gtk_doc
# python-behave required
%def_disable installed_tests

Name: eog
Version: %ver_major.2
Release: alt1

Summary: Eye Of Gnome
License: %gpl2plus
Group: Graphics
Url: https://wiki.gnome.org/Apps/EyeOfGnome

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Provides: %oldname = %version-%release
Obsoletes: %oldname < 2.14.2-alt1

%add_findprov_lib_path %_libdir/%name
%set_typelibdir %_libdir/%name/girepository-1.0
%set_girdir %_datadir/%name/gir-1.0

# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_path %_libdir/%name/plugins
# required dogtail and behave use python2
#%{?_enable_installed_tests:%_libexecdir/%name/installed-tests}

BuildRequires(pre): meson rpm-build-gnome rpm-build-licenses
BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel yelp-tools libappstream-glib-devel
BuildPreReq: libgtk+3-devel >= 3.22
BuildPreReq: libgio-devel >= 2.42.0
BuildPreReq: libgnome-desktop3-devel >= 3.0
BuildPreReq: gnome-icon-theme >= 2.19.1
BuildPreReq: shared-mime-info >= 0.60
BuildPreReq: libexempi-devel >= 1.99.5
BuildPreReq: libexif-devel >= 0.6.14
%{?_enable_color_management:BuildPreReq: liblcms2-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
BuildPreReq: libjpeg-devel librsvg-devel
BuildPreReq: libpeas-devel >= 0.7.4
BuildRequires: libXt-devel libxml2-devel perl-XML-Parser zlib-devel gsettings-desktop-schemas-devel
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.10.2 libgtk+3-gir-devel}

%description
This is the Eye of GNOME, an image viewer program. It is meant to be
a fast and functional image viewer as well as an image cataloging
program.

%package devel
Summary: Development files for EOG viewer
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
This package contains files necessary to develop plugins for Eye of GNOME.

%package devel-doc
Summary: Development documentation for EOG viewer
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains documentation necessary to develop plugins for Eye
of GNOME.

%package gir
Summary: GObject introspection data for the EOG
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Eye of GNOME

%package gir-devel
Summary: GObject introspection devel data for the EOG
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Eye of GNOME

%package tests
Summary: Tests for the EOG
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the EOG GUI.


%prep
%setup

%build
%meson \
    -Dlibexif=true \
    -Dxmp=true \
    -Dlibjpeg=true \
    -Dlibrsvg=true \
    -Denable-schemas-compile=false \
    %{?_enable_introspection:-Dintrospection=true} \
    %{?_enable_color_management:-Dcms=true} \
    %{?_enable_installed_tests:-Dinstalled-tests=true} \
    %{?_enable_gtk_doc:-Dgtk_doc=true}

%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%dir %_datadir/%name
%_datadir/%name/icons/
%dir %_libdir/%name
%_libdir/%name/lib%name.so
%dir %_libdir/%name/plugins/
%_libdir/%name/plugins/*.so
%_libdir/%name/plugins/*.plugin
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%config %_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/GConf/gsettings/eog.convert
%_datadir/metainfo/%name.appdata.xml
%doc AUTHORS HACKING MAINTAINERS NEWS
%doc README THANKS TODO

%files devel
%dir %_includedir/%name-%api_ver/%name
%_includedir/%name-%api_ver/%name/*.h
%_pkgconfigdir/%name.pc

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files gir
%_libdir/%name/girepository-1.0/Eog-%api_ver.typelib

%files gir-devel
%_datadir/%name/gir-1.0/Eog-%api_ver.gir
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/%name/installed-tests/
%_datadir/installed-tests/%name/
%endif


%changelog
