%def_disable snapshot
%set_verify_elf_method unresolved=relaxed

%define _libexecdir %_prefix/libexec

%define ver_major 3.32
%define api_ver 3.10
%define ua_ver 3.24
%define xdg_name org.gnome.Epiphany

Name: epiphany
Version: %ver_major.5
Release: alt1

Summary: Epiphany is a GNOME web browser.
Summary(ru_RU.UTF-8): Epiphany - интернет-браузер для графической оболочки GNOME.
Group: Networking/WWW
License: GPLv3+
Url: http://www.gnome.org/projects/%name

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

Provides: webclient
Obsoletes: %name-extensions

%add_findprov_lib_path %_libdir/%name

%define webkit_ver 2.24.0
%define gtk_ver 3.24.0
%define libxml2_ver 2.6.12
%define xslt_ver 1.1.7
%define soup_ver 2.48.0
%define secret_ver 0.14
%define gcr_ver 3.5.5
%define dazzle_ver 3.32.0
%define handy_ver 0.0.9

Requires: %name-data = %version-%release indexhtml iso-codes

BuildRequires(pre): meson
BuildRequires: gcc-c++ yelp-tools libappstream-glib-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libxslt-devel >= %xslt_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: gcr-libs-devel >= %gcr_ver
BuildRequires: libdazzle-devel >= %dazzle_ver
BuildRequires: libnotify-devel libsqlite3-devel
BuildRequires: libnettle-devel
BuildRequires: iso-codes-devel >= 0.35
BuildRequires: gcc-c++ gsettings-desktop-schemas-devel
BuildRequires: libicu-devel libjson-glib-devel
BuildRequires: libhandy-devel >= %handy_ver
%description
Epiphany is a GNOME web browser based on the Webkit rendering engine.

%description -l ru_RU.UTF-8
Epiphany - интернет-браузер для графической оболочки GNOME, основанный на
движке отрисовки страниц Webkit.

%package data
Summary: Epiphany data files
Group: Networking/WWW
BuildArch: noarch

%description data
Epiphany is a GNOME web browser based on the Webkit rendering engine.
This package contains common noarch files needed for Epiphany.

%prep
%setup

%build
%meson \
	-Ddistributor_name="ALTLinux"
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name

%files
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/ephy-profile-migrator
%_libexecdir/%name-search-provider
%dir %_libdir/%name
%_libdir/%name/*.so
%dir %_libdir/%name/web-extensions
%_libdir/%name/web-extensions/libephywebextension.so
%doc NEWS README* TODO

%files data -f %name.lang
%_desktopdir/%xdg_name.desktop
%_datadir/%name
%_datadir/dbus-1/services/*
%config %_datadir/glib-2.0/schemas/org.gnome.epiphany.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Epiphany.enums.xml
%_man1dir/*
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
