%define _unpackaged_files_terminate_build 1

%global realname xmpp

%set_verify_elf_method relaxed

Name: erlang-%realname
Version: 1.5.4
Release: alt1
Summary: Erlang/Elixir XMPP parsing and serialization library on top of Fast XML
Group: Development/Erlang
License: Apache-2.0
Url: https://github.com/processone/xmpp

# https://github.com/processone/xmpp.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-erlang
BuildRequires: erlang-otp-devel erlang-devel
BuildRequires: /usr/bin/rebar
BuildRequires: erlang-p1_utils
BuildRequires: erlang-fast_xml
BuildRequires: erlang-stringprep
BuildRequires: erlang-fast_tls
BuildRequires: erlang-ezlib
BuildRequires: erlang-idna

%description
The library provides comprehensive representation of XMPP elements
as well as tools to work with them.
Every such element is represented by an Erlang record.
Most of the library's code is auto generated
and thus considered to be bug free and efficient.

The approach is very similar to ASN.1, Google Protocol Buffers
or Apache Thrift: an XML element is transformed
into internal language structure (an Erlang record in our case)
- the process known as "decoding".
During decoding, validation is also performed,
thus well-typed structures are generated,
potentially decreasing bugs related to handcrafted parsing.
A reverse process known as "encoding" is applied
for transforming an Erlang record into an XML element.

The library should be used along with fast_xml library,
because it is only able to decode from and encode
to structures generated by that library (that is, xmlel() elements).

%prep
%setup

%build
%autoreconf
%configure
%rebar_compile

%install
%rebar_install %realname

%check
%rebar_eunit -C rebar.test.config

%files
%doc LICENSE.*
%doc doc README.md
%_erllibdir/%realname-%version

%changelog
