%define _unpackaged_files_terminate_build 1

Name: etckeeper
Version: 1.18.8
Release: alt1

Summary: Etckeeper help to keep your /etc directory in VCS repository
License: GPL2+
Group: Development/Other
Url: http://etckeeper.branchable.com
Source: %name-%version.tar
Patch: %name-%version-%release.patch
BuildArch: noarch
AutoReq: yes,noshell
Requires: coreutils diffutils findutils grep sh
Requires: git-core >= 1.6.0
Requires: perl-base
Obsoletes: %name-origin < %version-%release

Packager: Evgenii Terechkov <evg@altlinux.org>

%description
etckeeper is a collection of tools to let /etc be stored in a VCS
repository. It hooks into apt/yum/packman/etc to automatically commit
changes made to /etc during package upgrades. It's quite modular and
configurable, while also being simple to use if you understand the
basics of working with VCS.

%prep
%setup
%patch -p1

%build
%install
make install DESTDIR=%buildroot
install -D debian/cron.daily %buildroot%_sysconfdir/cron.daily/%name

# We dont want bzr now:
rm -rf %buildroot%_libdir/python*
# There is no cruft package for ALT:
rm -rf %buildroot%_sysconfdir/cruft

mv -v %buildroot%_sysconfdir/apt/apt.conf.d/05%name %buildroot%_sysconfdir/apt/apt.conf.d/%name.conf

%post
if [ -e %_sysconfdir/.git/hooks/pre-commit ] && egrep '^(/us[rb]/s?bin/)?%name' %_sysconfdir/.git/hooks/pre-commit >/dev/null 2>&1; then
 echo "Replacing path to etckeeper in %_sysconfdir/.git/hooks/pre-commit"
 sed -i 's!^/usr/sbin/etckeeper!etckeeper!;s!^/usr/bin/etckeeper!etckeeper!;s!^/usb/sbin/etckeeper!etckeeper!' %_sysconfdir/.git/hooks/pre-commit
fi

%files
%_bindir/%name
%_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%_sysconfdir/apt/apt.conf.d/%name.conf
%_man8dir/%{name}.*
/usr/share/bash-completion/completions/%name
%_cachedir/%name
%_sysconfdir/cron.daily/%name
%_unitdir/%{name}.*
%doc README.md

%changelog
