%def_disable snapshot
%set_verify_elf_method unresolved=relaxed
# Some plugins/extensions link with others, resulting in multiple rpath entries
%set_verify_elf_method rpath=relaxed

%define xdg_name org.gnome.Evolution
%define _libexecdir %_prefix/libexec
%define ver_major 3.32
%define ver_base 3.32
%define gst_api_ver 1.0

%def_disable gtk_doc
%def_with openldap
%def_disable static_ldap
%def_enable map
%def_enable autoar
%def_enable ytnef
%def_enable installed_tests

# %define plugins experimental
%define plugins all

Name: evolution
Version: %ver_major.4
Release: alt1

Summary: Integrated GNOME mail client, calendar and address book
License: GPLv2+
Group: Office
Url: https://wiki.gnome.org/Apps/Evolution

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

%define evo_plugin_dir %_libdir/evolution/plugins
%define evo_module_dir %_libdir/evolution/modules
%add_findprov_lib_path %_libdir/%name/%ver_base

Provides: camel

# from configure.ac
%define glib_ver 2.40.0
%define gtk_ver 3.10
%define clutter_gtk_ver 0.91.8
%define eds_ver 3.32.4
%define gnome_icon_ver 3.0.0
%define gnome_desktop_ver 2.91.6
%define libsoup_ver 2.42.0
%define libnotify_ver 0.7.0
%define gweather_ver 3.5.0
%define ical_ver 1.0.1
%define gdata_ver 0.10.0
%define champlain_ver 0.12
%define pst_ver 0.6.54
%define webkit_ver 2.13.90
%define geocode_ver 3.10.0
%define gcr_ver 3.4
%define autoar_ver 0.1.1

Requires: %name-data = %version-%release
Requires: evolution-data-server >= %eds_ver
Requires: gnome-icon-theme
Requires: gnome-settings-daemon
Requires: highlight

BuildRequires: cmake gcc-c++ flex  gnome-common
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgail3-devel >= %gtk_ver
BuildRequires: gnome-icon-theme >= %gnome_icon_ver
BuildRequires: evolution-data-server-devel >= %eds_ver
BuildRequires: libgnome-desktop3-devel >= %gnome_desktop_ver
BuildRequires: libsoup-gnome-devel >= %libsoup_ver
BuildRequires: libnotify-devel >= %libnotify_ver
BuildRequires: libgweather-devel >= %gweather_ver
BuildRequires: libical-devel >= %ical_ver libicu-devel
BuildRequires: libgdata-devel >= %gdata_ver
BuildRequires: libpst-devel >= %pst_ver
BuildRequires: libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libclutter-gtk3-devel >= %clutter_gtk_ver
BuildRequires: gcr-libs-devel >= %gcr_ver libcryptui-devel
BuildRequires: libkrb5-devel
%{?_enable_map:BuildRequires: libchamplain-gtk3-devel >= %champlain_ver libgeocode-glib-devel >= %geocode_ver}
%{?_enable_ytnef:BuildRequires: libytnef-devel}
%{?_enable_autoar:BuildRequires: libgnome-autoar-devel >= %autoar_ver}
%{?_with_openldap:BuildRequires: libldap-devel %{?_enable_static_ldap:libldap-devel-static libssl-devel libsasl2-devel}}

BuildRequires: docbook-utils intltool yelp-tools itstool gtk-doc
BuildRequires: libSM-devel libcom_err-devel gstreamer%gst_api_ver-devel
BuildRequires: libnspr-devel libnss-devel libX11-devel libcanberra-gtk3-devel
BuildRequires: zlib-devel libxml2-devel libgtkspell3-devel

%description
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

%package data
Summary: Evolution data files
Group: Office
BuildArch: noarch

%description data
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

This package contains common noarch files needed for  Evolution.

%package bogofilter
Group: Networking/Mail
Summary: Bogofilter plugin for Evolution
Requires: %name = %version-%release
Requires: bogofilter

%description bogofilter
This package contains the plugin to filter junk mail using Bogofilter.

%package spamassassin
Group: Networking/Mail
Summary: SpamAssassin plugin for Evolution
Requires: %name = %version-%release
Requires: spamassassin

%description spamassassin
This package contains the plugin to filter junk mail using SpamAssassin.

%package devel
Summary: Evolution development files
Group: Development/C
Requires: %name = %version-%release
Requires: evolution-data-server-devel >= %eds_ver

%description devel
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

This package contains files needed to develop Evolution plugins.

%package devel-doc
Summary: Evolution development documentation
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

This package contains documentation needed to develop Evolution plugins.

%package tests
Summary: Tests for the Evolution
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Evolution.


%prep
%setup

%build
# reenable RPATH* to link against private libraries
%cmake \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	-DCMAKE_BUILD_WITH_INSTALL_RPATH:BOOL=ON \
	-DKILL_PROCESS_COMMAND:STRING=%_bindir/killall \
	-DENABLE_SCHEMAS_COMPILE:BOOL=OFF \
	-DENABLE_SMIME:BOOL=ON \
	%{?_enable_autoar:-DENABLE_AUTOAR:BOOL=ON} \
	%{?_enable_ytnef:-DENABLE_YTNEF:BOOL=ON} \
	%{?_enable_map:-DENABLE_CONTACT_MAPS:BOOL=ON} \
	%{?_with_openldap:-DWITH_OPENLDAP:BOOL=ON} \
	%{?_with_static_ldap:-DWITH_STATIC_LDAP:BOOL=ON} \
	%{?_enable_gtk_doc:-DENABLE_GTK_DOC:BOOL=ON} \
	%{?_enable_installed_tests:-DENABLE_INSTALLED_TESTS:BOOL=ON} \
	-DVERSION_SUBSTRING:STRING=-%release
%cmake_build

%install
%cmakeinstall_std

# evolution command name
mv %buildroot%_bindir/evolution %buildroot%_bindir/evolution-%ver_major
ln -s %name-%ver_major %buildroot%_bindir/%name

# remove non-packaged files
find %buildroot -type f -name "*.la" -print0 | xargs -r0 rm --

%find_lang --with-gnome --output=%name.lang %name %name-%ver_base

%files
%_bindir/*
%_libdir/%name/
%_libdir/evolution-data-server/ui-modules/module-evolution-alarm-notify.so
%_libexecdir/%name/evolution-backup
%_libexecdir/%name/killev
%doc AUTHORS ChangeLog NEWS README

%exclude %evo_module_dir/module-bogofilter.so
%exclude %evo_module_dir/module-spamassassin.so

%files data -f %name.lang
%_desktopdir/*
%_datadir/%name/
%_datadir/glib-2.0/schemas/org.gnome.evolution.addressbook.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.importer.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.mail.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.attachment-reminder.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.autocontacts.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.email-custom-header.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.external-editor.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.face-picture.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.itip.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.mail-notification.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.prefer-plain.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.publish-calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.templates.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.shell.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.text-highlight.gschema.xml
%_datadir/GConf/gsettings/evolution.convert
%_iconsdir/hicolor/*/*/*
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/metainfo/%xdg_name-pst.metainfo.xml

%files devel
%_includedir/*
%_pkgconfigdir/*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%files bogofilter
%evo_module_dir/module-bogofilter.so
%_datadir/glib-2.0/schemas/org.gnome.evolution.bogofilter.gschema.xml
%_datadir/metainfo/%xdg_name-bogofilter.metainfo.xml

%files spamassassin
%evo_module_dir/module-spamassassin.so
%_datadir/glib-2.0/schemas/org.gnome.evolution.spamassassin.gschema.xml
%_datadir/metainfo/%xdg_name-spamassassin.metainfo.xml

%if_enabled installed_tests
%files tests
%_libexecdir/%name/installed-tests/
%_datadir/installed-tests/%name/
%endif


%changelog
