Name: fdutils

%define ver_base 5.5
%define ver_snap 20081027
%define srcname %name-%ver_base

%ifdef ver_snap
Version: %ver_base.%ver_snap
%else
Version: %ver_base
%endif
Release: alt2

Summary: Programs for dealing with floppy disks
License: GPLv2+
Group: System/Kernel and hardware
Url: http://fdutils.linux.lu

# %url/%srcname.tar.gz
Source: %srcname.tar
%ifdef ver_snap
# %url/%name-%ver_base-%ver_snap.diff.gz
Patch1: %name-%ver_base-%ver_snap.diff
%endif
Patch2: fdutils-5.5-20060227-alt-headers.patch
Patch3: fdutils-5.4-alt-texinfo.patch
Patch4: fdutils-alt-nodvi.patch
Patch5: fdutils-alt-ext2_fs.patch

Requires: util-linux >= 2.11h-alt2

BuildRequires: flex libe2fs-devel makeinfo

Summary(ru_RU.UTF-8): Утилиты для форматирования дискет и управления флоппи-драйвером Линукса

%description
This package contains utilities for configuring and debugging the
Linux floppy driver, for formatting extra capacity disks (up to 1992K
on a high density disk), for sending raw commands to the floppy
controller, etc.

%description -l ru_RU.UTF-8
Утилиты для настройки и отладки системного драйвера флоппи-дисков,
форматирования дискет с увеличенной плотностью (до 1992 килобайт),
прямого управления контроллером дисковода и т.д.

%prep
%setup -q -n %srcname
%ifdef ver_snap
%patch1 -p1
%endif
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
%configure
# SMP-incompatible
make

%install
mkdir -p %buildroot{%_sysconfdir,%_bindir,%_infodir,%_man1dir,%_man4dir}
%makeinstall UID=$(id -u) GID=$(id -g)

install -p -m644 src/mediaprm %buildroot%_sysconfdir
chmod 755 %buildroot%_bindir/*

# man-pages
rm %buildroot%_man4dir/fd.4*

%files
%config %_sysconfdir/mediaprm
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc CREDITS Changelog doc/FAQ.html doc/README doc/floppy_formats

%changelog
