Name: filesystem
Version: 2.3.18
Release: alt1

Summary: The basic directory layout for a GNU/Linux system
License: Public Domain
Group: System/Base

Source0: %name-dir.list
Source1: %name-link.list
Source2: %name-dir64.list
source3: %name-dir-x32.list
# Traditional MCST paths:
Source4: %name-dir-e2k32.list

PreReq: setup

Provides: /var/empty /var/lock/serial
Provides: /media /proc /run /selinux /srv /sys
Provides: /usr/share/wallpapers
Provides: /usr/share/icons/hicolor
# http://bugzilla.altlinux.org/12020
Provides: /dev/pts
Provides: /dev/shm

Conflicts: shadow-utils < 4.4

%description
This package is one of the basic packages that is installed on a
%distribution system.  Filesystem contains the basic directory layout
for a FHS-compatible GNU/Linux operating system, including the correct
permissions for the directories.

%prep
%setup -cT

%build
{
	cat %_sourcedir/%name-dir.list
%if "%_lib" == "lib64"
	cat %_sourcedir/%name-dir64.list
%endif
%ifarch x32
	cat %_sourcedir/%name-dir64.list
%endif
%ifarch x86_64 x32
	cat %_sourcedir/%name-dir-x32.list
%endif
%ifarch %e2k
	cat %_sourcedir/%name-dir-e2k32.list
%endif
} > dir.list

{
	cat dir.list
	echo '%%defattr(-,root,root,-)'
	cut -d' ' -f1 < %_sourcedir/%name-link.list
} > list

%install
mkdir %buildroot

while read attr dir name extra; do
	mkdir "%buildroot$name"
done < dir.list

while read source target; do
	ln -s "$target" "%buildroot$source"
done < %_sourcedir/%name-link.list

%files -f list

%changelog
