Summary:              The Mozilla Firefox project is a redesign of Mozilla's browser
Summary(ru_RU.UTF-8): Интернет-браузер Mozilla Firefox

Name: firefox
Version: 105.0.1
Release: alt0.c9.1
License: MPL-2.0
Group: Networking/WWW
URL: https://www.mozilla.org/firefox/

Source0: firefox-source.tar

### Start Patches
Patch001: 0001-FEDORA-build-arm-libopus.patch
Patch002: 0002-FEDORA-build-arm.patch
Patch003: 0003-ALT-Fix-aarch64-build.patch
Patch004: 0004-MOZILLA-1196777-GTK3-keyboard-input-focus-sticks-on-.patch
Patch005: 0005-MOZILLA-1170092-Search-for-default-preferences-in-et.patch
Patch006: 0006-use-floats-for-audio-on-arm-too.patch
Patch007: 0007-bmo-847568-Support-system-harfbuzz.patch
Patch008: 0008-bmo-847568-Support-system-graphite2.patch
Patch009: 0009-bmo-1559213-Support-system-av1.patch
Patch010: 0010-Revert-Bug-1712947-Don-t-pass-neon-flags-to-rustc-wh.patch
Patch011: 0011-ALT-fix-double_t-redefinition.patch
Patch012: 0012-build-Disable-Werror.patch
### End Patches

%define _unpackaged_files_terminate_build 1
%set_verify_elf_method relaxed

%ifndef build_parallel_jobs
%global build_parallel_jobs %__nprocs
%endif

%define gst_version   1.0
%define nspr_version  4.34.1
%define nss_version   3.82
%define rust_version  1.64.0
%define cargo_version 1.64.0
%define llvm_version  12.0

BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): rpm-build-firefox
BuildRequires(pre): browser-plugins-npapi-devel

BuildRequires: clang%llvm_version
BuildRequires: clang%llvm_version-devel
BuildRequires: llvm%llvm_version-devel
BuildRequires: lld%llvm_version-devel
BuildRequires: libstdc++-devel
BuildRequires: rpm-macros-alternatives
BuildRequires: rust >= %rust_version
BuildRequires: rust-cargo >= %cargo_version
BuildRequires: node
BuildRequires: nasm yasm
BuildRequires: zip unzip
BuildRequires: libshell
BuildRequires: libwireless-devel
BuildRequires: libnss-devel-static
BuildRequires: xorg-cf-files chrpath alternatives
BuildRequires: gstreamer%gst_version-devel gst-plugins%gst_version-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(aom)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(dav1d)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(dri)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(graphite2)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(hunspell)
BuildRequires: pkgconfig(icu-i18n)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libevent)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libnotify)
BuildRequires: pkgconfig(libproxy-1.0)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libstartup-notification-1.0)
BuildRequires: pkgconfig(nspr) >= %nspr_version
BuildRequires: pkgconfig(nss) >= %nss_version
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(vpx)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xft)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xscrnsaver)
BuildRequires: pkgconfig(xt)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(zlib)

# Python requires
BuildRequires: /dev/shm

BuildRequires: python3-base
BuildRequires: python3(hamcrest)
BuildRequires: python3(pip)
BuildRequires: python3(setuptools)
BuildRequires: python3(sqlite3)

# Rust requires
BuildRequires: /proc

Provides: webclient
Requires: mozilla-common

Obsoletes: firefox-ru <= 70.0.1
Obsoletes: firefox-uk <= 70.0.1
Obsoletes: firefox-kk <= 70.0.1
Obsoletes: firefox-wayland <= 104.0.2

Provides: firefox-ru = %EVR
Provides: firefox-uk = %EVR
Provides: firefox-kk = %EVR
Provides: firefox-wayland = %EVR

# ALT#30732
Requires: gst-plugins-ugly%gst_version

Requires: libnspr >= %nspr_version
Requires: libnss >= %nss_version

%description
The Mozilla Firefox project is a redesign of Mozilla's browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -l ru_RU.UTF-8
Интернет-браузер Mozilla Firefox - кроссплатформенная модификация браузера Mozilla,
созданная с использованием языка XUL для описания интерфейса пользователя.

%package -n firefox-config-privacy
Summary:	Firefox configuration with the paranoid privacy settings
Group:		System/Configuration/Networking
BuildArch:	noarch

Requires: %name >= %version-%release

%description -n firefox-config-privacy
Settings disable:
* obsolete ssl protocols;
* safebrowsing, trackingprotection and other requests to third-party services;
* telemetry;
* webrtc;
* the social features;
* dns and network predictors/prefetch;
* and some more...

Most likely you don't need to use this package.

%prep
%setup -q -n firefox-%version -c
%autopatch -p1

mv -- .rpm/l10n .
cp -f .rpm/firefox-mozconfig .mozconfig

tee -a .mozconfig <<'EOF'
ac_add_options --prefix="%_prefix"
ac_add_options --libdir="%_libdir"
%ifnarch %{ix86} ppc64le
ac_add_options --enable-linker=lld
%ifnarch armh
ac_add_options --enable-lto=thin
%endif
%endif
%ifarch armh ppc64le
ac_add_options --disable-webrtc
%endif
%ifarch armh %{ix86} x86_64
ac_add_options --disable-elf-hack
%endif
%ifarch %{ix86}
ac_add_options --disable-av1
%endif
%ifarch armh %{ix86}
ac_add_options --enable-strip
ac_add_options --enable-install-strip
ac_add_options --disable-rust-debug
ac_add_options --disable-debug-symbols
%else
ac_add_options --disable-strip
ac_add_options --disable-install-strip
%endif
mk_add_options MOZ_MAKE_FLAGS="-j%build_parallel_jobs --no-print-directory"
EOF

find third_party \
	-type f \( -name '*.so' -o -name '*.o' -o -name '*.a' \) \
	-delete

rm -rf -- obj-x86_64-pc-linux-gnu
rm -rf -- third_party/python/setuptools/setuptools*


%build
%add_findprov_lib_path %firefox_prefix

export MOZ_BUILD_APP=browser
export MOZ_CHROME_MULTILOCALE="$(tr '\n' ' ' < .rpm/firefox-l10n.txt)"

MOZ_OPT_FLAGS="-pipe -O2 -g0"
%ifarch armh
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -march=armv7-a -mthumb"
%endif

# PIE, full relro
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -DPIC -fPIC -Wl,-z,relro -Wl,-z,now"

# Add fake RPATH
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -Wl,-rpath,/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"

# If MOZ_DEBUG_FLAGS is empty, firefox's build will default it to "-g" which
# overrides the -g0 from line above and breaks building on s390
# (OOM when linking, rhbz#1238225)
export MOZ_DEBUG_FLAGS=" "

export CFLAGS="$MOZ_OPT_FLAGS"
export CXXFLAGS="$MOZ_OPT_FLAGS"

export MOZ_PARALLEL_BUILD=%build_parallel_jobs
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export RANLIB="llvm-ranlib"
export LLVM_PROFDATA="llvm-profdata"
export ALTWRAP_LLVM_VERSION="%llvm_version"

export LIBIDL_CONFIG=/usr/bin/libIDL-config-2
export SHELL=/bin/sh

export RUST_BACKTRACE=1
%ifarch armh %{ix86}
export RUSTFLAGS="-Clink-args=-fPIC -Cdebuginfo=0"
%else
export RUSTFLAGS="-Clink-args=-fPIC -Cdebuginfo=2"
%endif

CBINDGEN_HOME="$PWD/.rpm/cbindgen-vendor"
CBINDGEN_BINDIR="$CBINDGEN_HOME/bin"

if [ ! -x "$CBINDGEN_BINDIR/cbindgen" ]; then
	cat > "$CBINDGEN_HOME/config" <<-EOF
	[source.crates-io]
	replace-with = "vendored-sources"

	[source.vendored-sources]
	directory = "$CBINDGEN_HOME"
	EOF

	env CARGO_HOME="$CBINDGEN_HOME" \
		cargo install cbindgen

	export PATH="$CBINDGEN_BINDIR:$PATH"
fi

#export WASM_SANDBOXED_LIBRARIES=graphite,ogg
#export WASM_CC="$CC --target=wasm32-wasi"
#export WASM_CXX="$CXX --target=wasm32-wasi"

export srcdir="$PWD"
export MOZBUILD_STATE_PATH="$srcdir/mozbuild"
export MACH_USE_SYSTEM_PYTHON=1

python3 ./mach build

while read -r loc; do
	python3 ./mach build chrome-$loc
done < .rpm/firefox-l10n.txt

make -C objdir/browser/installer multilocale.txt

$CC $CFLAGS \
	-Wall -Wextra \
	-DMOZ_PLUGIN_PATH=\"%browser_plugins_path\" \
	-DMOZ_PROGRAM=\"%firefox_prefix/firefox\" \
	-DMOZ_DIST_BIN=\"%firefox_prefix\"\
	.rpm/firefox.c -o firefox


%install
export SHELL=/bin/sh
export MOZ_CHROME_MULTILOCALE="$(tr '\n' ' ' < .rpm/firefox-l10n.txt)"

mkdir -p \
	%buildroot/%mozilla_arch_extdir/%firefox_cid \
	%buildroot/%mozilla_noarch_extdir/%firefox_cid \
	#

make -C objdir \
	DESTDIR=%buildroot \
	INSTALL="/bin/install -p" \
	mozappdir=%firefox_prefix \
	libdir=%_libdir \
	install

# install altlinux-specific configuration
install -D -m 644 .rpm/firefox-prefs.js %buildroot/%firefox_prefix/browser/defaults/preferences/all-altlinux.js
install -D -m 644 .rpm/firefox-privacy-prefs.js %buildroot/%_sysconfdir/firefox/pref/all-privacy.js

sed -i \
	-e 's#@VERSION@#%{version}#g' \
	%buildroot/%_sysconfdir/firefox/pref/all-privacy.js

cat > %buildroot/%firefox_prefix/browser/defaults/preferences/firefox-l10n.js <<EOF
pref("intl.locale.matchOS", true);
pref("intl.locale.requested", "");
pref("general.useragent.locale", "chrome://global/locale/intl.properties");
EOF

# icons
for s in 16 22 24 32 48 256; do
	install -D -m 644 \
		browser/branding/official/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/firefox.png
done

# ALT#30572
if [ ! -e "%buildroot/%firefox_prefix/plugins" ]; then
	what="$(relative %browser_plugins_path %firefox_prefix/plugins)"
	ln -s -- "$what" %buildroot/%firefox_prefix/plugins
fi

install -m755 firefox %buildroot/%_bindir/firefox
ln -s firefox %buildroot/%_bindir/firefox-wayland

install -D -m 644 .rpm/distribution.ini \
	%buildroot/%firefox_prefix/distribution/distribution.ini

install -D -m 644 .rpm/firefox.desktop \
	%buildroot/%_datadir/applications/firefox.desktop

install -D -m 644 .rpm/firefox-search-provider.ini \
	%buildroot/%_datadir/gnome-shell/search-providers/firefox-search-provider.ini

# Add alternatives
mkdir -p %buildroot/%_altdir
cat >%buildroot/%_altdir/firefox <<EOF
%_bindir/xbrowser	%_bindir/firefox	200
%_bindir/x-www-browser	%_bindir/firefox	200
EOF

rm -f -- \
	%buildroot/%firefox_prefix/removed-files

# Remove devel files
rm -rf -- \
	%buildroot/%_includedir/%name \
	%buildroot/%_datadir/idl/%name \
	%buildroot/%_libdir/%name-devel \
#


# Add real RPATH
(set +x
	rpath="/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"
	find %buildroot -type f |
	while read f; do
		t="$(readlink -ev "$f")"
		file "$t" | fgrep -qs ELF ||
			continue
		chrpath -l "$t" |
			fgrep -qs \
				-e "RPATH=$rpath" \
				-e "RUNPATH=$rpath" ||
			continue
		chrpath -r "%firefox_prefix" "$t"
	done
)

%files
%dir %_sysconfdir/firefox
%dir %_sysconfdir/firefox/pref
%_altdir/firefox
%_bindir/firefox
%_bindir/firefox-wayland
%firefox_prefix
%mozilla_arch_extdir/%firefox_cid
%mozilla_noarch_extdir/%firefox_cid
%_datadir/applications/firefox.desktop
%_datadir/gnome-shell/search-providers/firefox-search-provider.ini
%_iconsdir/hicolor/16x16/apps/firefox.png
%_iconsdir/hicolor/22x22/apps/firefox.png
%_iconsdir/hicolor/24x24/apps/firefox.png
%_iconsdir/hicolor/32x32/apps/firefox.png
%_iconsdir/hicolor/48x48/apps/firefox.png
%_iconsdir/hicolor/256x256/apps/firefox.png

%files -n firefox-config-privacy
%config(noreplace) %_sysconfdir/firefox/pref/all-privacy.js

%changelog
