%define _unpackaged_files_terminate_build 1

Name: firejail
Version: 0.9.64
Release: alt1
Summary: Linux namespaces sandbox program
License: GPLv2+
Group: Development/Tools
Url: https://firejail.wordpress.com/

# https://github.com/netblue30/firejail.git
Source: %name-%version.tar

%description
Firejail is a SUID sandbox program that reduces the risk of security
breaches by restricting the running environment of untrusted applications
using Linux namespaces. It includes a sandbox profile for Mozilla Firefox.

%prep
%setup

%build
%configure --disable-userns
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%doc README* RELNOTES COPYING
%_bindir/%name
%_bindir/firecfg
%_bindir/firemon
%_libdir/%name
%_datadir/bash-completion/completions/%name
%_datadir/bash-completion/completions/firecfg
%_datadir/bash-completion/completions/firemon
%_datadir/vim/vimfiles/ftdetect/%name.vim
%_datadir/vim/vimfiles/syntax/%name.vim
%exclude %_docdir/%name
%_man1dir/%name.1*
%_man1dir/firecfg.1*
%_man1dir/firemon.1*
%_man5dir/%name-login.5*
%_man5dir/%name-profile.5*
%_man5dir/%name-users.5*
%config %_sysconfdir/%name

%changelog
